/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.MySqlUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.OracleUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.PostgresUrlParser;
import com.atlassian.jira.config.database.jdbcurlparser.SqlServerUrlParser;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public enum DatabaseType {
    H2("H2", "h2", "unknown", null, (ImmutableList<String>)ImmutableList.of((Object)"org.h2.Driver")),
    HSQL("HSQL", "hsql", "unknown", null, (ImmutableList<String>)ImmutableList.of((Object)"org.hsqldb.jdbcDriver")),
    SQL_SERVER("SQL Server", "mssql", "Database", new SqlServerUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"net.sourceforge.jtds.jdbc.Driver", (Object)"com.microsoft.jdbc.sqlserver.SQLServerDriver")),
    MY_SQL("MySQL", "mysql", "Database", new MySqlUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"com.mysql.jdbc.Driver")),
    ORACLE("Oracle", "oracle10g", "SID", new OracleUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"oracle.jdbc.OracleDriver")),
    POSTGRES("PostgreSQL", "postgres72", "Database", new PostgresUrlParser(), (ImmutableList<String>)ImmutableList.of((Object)"org.postgresql.Driver")),
    UKNOWN("Uknown", "unknown", "unknown", null, (ImmutableList<String>)ImmutableList.of());

    private final String name;
    private final String typeName;
    private final JdbcUrlParser jdbcUrlParser;
    private final ImmutableList<String> drivers;
    private final String instanceFieldName;

    private DatabaseType(String name, String typeName, String instanceFieldName, JdbcUrlParser jdbcUrlParser, ImmutableList<String> drivers) {
        this.name = name;
        this.typeName = typeName;
        this.instanceFieldName = instanceFieldName;
        this.jdbcUrlParser = jdbcUrlParser;
        this.drivers = drivers;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJdbcDriverClassName() {
        if (this.drivers.isEmpty()) {
            throw new RuntimeException("No Driver class name defined for " + this.name());
        }
        return (String)this.drivers.get(0);
    }

    public static Iterable<DatabaseType> knownTypes() {
        return Iterables.filter(DatabaseType.allTypes(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)((Object)UKNOWN))));
    }

    public static Iterable<DatabaseType> allTypes() {
        return ImmutableList.copyOf((Object[])DatabaseType.values());
    }

    public static DatabaseType forJdbcDriverClassName(final String jdbcDriverClass) {
        if (jdbcDriverClass == null) {
            return H2;
        }
        return (DatabaseType)((Object)Iterables.tryFind(DatabaseType.knownTypes(), (Predicate)new Predicate<DatabaseType>(){

            public boolean apply(DatabaseType databaseType) {
                return databaseType.drivers.contains((Object)jdbcDriverClass);
            }
        }).or((Supplier)new Supplier<DatabaseType>(){

            public DatabaseType get() {
                throw new IllegalArgumentException("Unknown JDBC Driver Class " + jdbcDriverClass);
            }
        }));
    }

    public static DatabaseType forDatabaseTypeName(final String typeName) {
        return (DatabaseType)((Object)Iterables.tryFind(DatabaseType.knownTypes(), (Predicate)new Predicate<DatabaseType>(){

            public boolean apply(DatabaseType databaseType) {
                return databaseType.getTypeName().contains(typeName);
            }
        }).or((Supplier)new Supplier<DatabaseType>(){

            public DatabaseType get() {
                throw new IllegalArgumentException("Unknown database type name " + typeName);
            }
        }));
    }

    public JdbcUrlParser getJdbcUrlParser() {
        if (this.jdbcUrlParser == null) {
            throw new UnsupportedOperationException("Parser implementation not available for " + this.name());
        }
        return this.jdbcUrlParser;
    }

    public String getInstanceFieldName() {
        return this.instanceFieldName;
    }
}

