/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.issue.status.category.StatusCategoryImpl;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import java.util.List;

public class DefaultStatusCategoryManager
implements StatusCategoryManager {
    public static final String JIRA_ISSUE_STATUS_AS_LOZENGE_FEATURE = "jira.issue.status.lozenge";
    private final FeatureManager featureManager;

    public DefaultStatusCategoryManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public List<StatusCategory> getStatusCategories() {
        return StatusCategoryImpl.getAllCategories();
    }

    public List<StatusCategory> getUserVisibleStatusCategories() {
        return StatusCategoryImpl.getUserVisibleCategories();
    }

    public StatusCategory getDefaultStatusCategory() {
        return StatusCategoryImpl.getDefault();
    }

    public StatusCategory getStatusCategory(Long id) {
        return StatusCategoryImpl.findById(id);
    }

    public StatusCategory getStatusCategoryByKey(String key) {
        return StatusCategoryImpl.findByKey(key);
    }

    public StatusCategory getStatusCategoryByName(String name) {
        return StatusCategoryImpl.findByName(name);
    }

    public boolean isStatusAsLozengeEnabled() {
        DarkFeatures darkFeatures = this.featureManager.getDarkFeatures();
        return darkFeatures.isFeatureEnabled(JIRA_ISSUE_STATUS_AS_LOZENGE_FEATURE);
    }
}

