/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.event.config.IssueTypeCreatedEvent;
import com.atlassian.jira.event.config.IssueTypeDeletedEvent;
import com.atlassian.jira.event.config.IssueTypeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueTypeManager
extends AbstractIssueConstantsManager<IssueType>
implements IssueTypeManager,
Startable {
    private static final String CREATION_LOCK_NAME = DefaultIssueTypeManager.class.getName() + ".creationLock";
    private final ProjectManager projectManager;
    private final WorkflowManager workflowManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final EventPublisher eventPublisher;
    private final IssueConstantFactory factory;
    private final ClusterLockService clusterLockService;
    private ClusterLock creationLock;

    public DefaultIssueTypeManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager, ProjectManager projectManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, WorkflowSchemeManager workflowSchemeManager, FieldConfigSchemeManager fieldConfigSchemeManager, CustomFieldManager customFieldManager, EventPublisher eventPublisher, IssueConstantFactory factory, ClusterLockService clusterLockService) {
        super(constantsManager, ofBizDelegator, issueIndexManager);
        this.projectManager = projectManager;
        this.workflowManager = workflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.customFieldManager = customFieldManager;
        this.eventPublisher = eventPublisher;
        this.factory = factory;
        this.clusterLockService = clusterLockService;
    }

    public void start() {
        this.creationLock = this.clusterLockService.getLockForName(CREATION_LOCK_NAME);
    }

    public IssueType createIssueType(String name, String description, String iconUrl) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, iconUrl, null);
    }

    public synchronized IssueType createIssueType(String name, String description, Long avatarId) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, avatarId, null);
    }

    public synchronized IssueType createSubTaskIssueType(String name, String description, String iconUrl) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, iconUrl, "jira_subtask");
    }

    public IssueType createSubTaskIssueType(String name, String description, Long avatarId) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, avatarId, "jira_subtask");
    }

    private IssueType createIssueTypeAndAddToDefaultScheme(String name, String description, Long avatarId, String style) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        try {
            String issueStyleType = StringUtils.trimToNull((String)style);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("style", issueStyleType);
            fields.put("id", this.getNextStringId());
            fields.put("avatar", avatarId);
            return this.createIssueTypeAndAddToDefaultScheme(issueStyleType, fields);
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create issue type with name '" + name + "'", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IssueType createIssueTypeAndAddToDefaultScheme(String issueStyleType, Map<String, Object> fields) {
        this.creationLock.lock();
        try {
            String name = (String)fields.get("name");
            for (IssueType it : this.getIssueTypes()) {
                if (!name.trim().equalsIgnoreCase(it.getName())) continue;
                throw new IllegalStateException("An issue type with the name '" + name + "' exists already.");
            }
            try {
                GenericValue issueTypeGV = this.createConstant(fields);
                this.issueTypeSchemeManager.addOptionToDefault(issueTypeGV.getString("id"));
                IssueType issueType = this.factory.createIssueType(issueTypeGV);
                this.eventPublisher.publish((Object)new IssueTypeCreatedEvent(issueType, issueStyleType));
                IssueType issueType2 = issueType;
                this.clearCaches();
                return issueType2;
            }
            catch (Throwable throwable) {
                this.clearCaches();
                throw throwable;
            }
        }
        finally {
            this.creationLock.unlock();
        }
    }

    private IssueType createIssueTypeAndAddToDefaultScheme(String name, String description, String iconUrl, String style) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notNull((String)"iconUrl", (Object)iconUrl);
        try {
            String issueStyleType = StringUtils.trimToNull((String)style);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("iconurl", iconUrl);
            fields.put("style", issueStyleType);
            fields.put("id", this.getNextStringId());
            return this.createIssueTypeAndAddToDefaultScheme(issueStyleType, fields);
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create issue type with name '" + name + "'", (Throwable)ex);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshIssueTypes();
    }

    public void editIssueType(IssueType issueType, String name, String description, String iconUrl) {
        Assertions.notNull((String)"issueType", (Object)issueType);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        for (IssueType it : this.getIssueTypes()) {
            if (!name.equalsIgnoreCase(it.getName()) || issueType.getId().equals(issueType.getId())) continue;
            throw new IllegalStateException("Cannot rename issue type. An issue type with the name '" + name + "' exists already.");
        }
        IssueTypeImpl updatedIssueType = (IssueTypeImpl)this.factory.createIssueType(((IssueTypeImpl)issueType).getGenericValue());
        updatedIssueType.setName(name);
        updatedIssueType.setDescription(description);
        updatedIssueType.setIconUrl(iconUrl);
        try {
            updatedIssueType.getGenericValue().store();
            this.eventPublisher.publish((Object)new IssueTypeUpdatedEvent((IssueType)updatedIssueType, null));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update issue type '" + name + "'", (Throwable)e);
        }
        finally {
            this.clearCaches();
        }
    }

    public void updateIssueType(IssueType issueType, String name, String description, Long avatarId) {
        Assertions.notNull((String)"issueType", (Object)issueType);
        Assertions.notBlank((String)"name", (String)name);
        IssueTypeImpl updatedIssueType = (IssueTypeImpl)this.factory.createIssueType(((IssueTypeImpl)issueType).getGenericValue());
        updatedIssueType.setName(name);
        updatedIssueType.setDescription(description);
        updatedIssueType.setAvatarId(avatarId);
        try {
            updatedIssueType.getGenericValue().store();
            this.eventPublisher.publish((Object)new IssueTypeUpdatedEvent((IssueType)updatedIssueType, null));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update issue type '" + name + "'", (Throwable)e);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<IssueType> getIssueTypes() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    public void removeIssueType(String id, String newIssueTypeId) {
        Assertions.notBlank((String)"id", (String)id);
        IssueType issueType = this.getIssueType(id);
        try {
            List workflowSchemes = this.workflowSchemeManager.getSchemes();
            for (GenericValue workflowScheme : workflowSchemes) {
                List entities = this.workflowSchemeManager.getEntities(workflowScheme);
                for (GenericValue entity : entities) {
                    if (!issueType.getId().equals(entity.getString("issuetype"))) continue;
                    this.workflowSchemeManager.deleteEntity(entity.getLong("id"));
                }
            }
            for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
                if (!fieldLayoutScheme.containsEntity(issueType.getId())) continue;
                fieldLayoutScheme.removeEntity(issueType.getId());
            }
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (!issueTypeScreenScheme.containsEntity(issueType.getId())) continue;
                issueTypeScreenScheme.removeEntity(issueType.getId());
            }
            this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForIssueType(issueType);
            this.customFieldManager.refresh();
            this.issueTypeSchemeManager.removeOptionFromAllSchemes(issueType.getId());
            this.removeConstant("type", issueType, newIssueTypeId);
            this.eventPublisher.publish((Object)new IssueTypeDeletedEvent(issueType, null));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }

    public IssueType getIssueType(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getIssueTypeObject(id);
    }

    public Collection<IssueType> getAvailableIssueTypes(IssueType issueType) {
        List projects = this.projectManager.getProjectObjects();
        try {
            CheckIssueTypeAssociationsResult checkIssueTypeAssociationsResult = this.checkIssueTypeAssociations(issueType, projects);
            if (!checkIssueTypeAssociationsResult.valid) {
                return Collections.emptyList();
            }
            IssueType issueTypeGV = this.constantsManager.getIssueTypeObject(issueType.getId());
            Collection issueTypes = this.constantsManager.getSubTaskIssueTypeObjects().contains(issueTypeGV) ? this.constantsManager.getSubTaskIssueTypeObjects() : this.constantsManager.getRegularIssueTypeObjects();
            Collection<IssueType> availableIssueTypes = this.getAlternativeTypes(issueType, issueTypes, projects, checkIssueTypeAssociationsResult.workflow, checkIssueTypeAssociationsResult.fieldScreenScheme, checkIssueTypeAssociationsResult.fieldLayoutId);
            return availableIssueTypes;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to read list of available issue types.", (Throwable)ex);
        }
    }

    public boolean hasAssociatedIssues(IssueType issueType) {
        try {
            List childIssue = ((IssueTypeImpl)issueType).getGenericValue().getRelated("ChildIssue");
            return childIssue != null && !childIssue.isEmpty();
        }
        catch (GenericEntityException e) {
            return false;
        }
    }

    @Override
    protected String getIssueConstantField() {
        return ConstantsManager.ISSUE_TYPE_CONSTANT_TYPE;
    }

    @Override
    protected List<IssueType> getAllValues() {
        return Lists.newArrayList((Iterable)this.constantsManager.getRegularIssueTypeObjects());
    }

    private CheckIssueTypeAssociationsResult checkIssueTypeAssociations(IssueType issueType, Collection<Project> projects) throws WorkflowException, GenericEntityException {
        JiraWorkflow workflow = null;
        FieldScreenScheme fieldScreenScheme = null;
        Long fieldLayoutId = null;
        for (Project project : projects) {
            if (workflow == null) {
                workflow = this.workflowManager.getWorkflow(project.getId(), issueType.getId());
                continue;
            }
            if (workflow.equals(this.workflowManager.getWorkflow(project.getId(), issueType.getId()))) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        int i = 0;
        for (FieldLayoutScheme layoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
            if (layoutScheme.getProjects().isEmpty()) continue;
            if (i == 0) {
                fieldLayoutId = layoutScheme.getFieldLayoutId(issueType.getId());
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)fieldLayoutId, (Object)layoutScheme.getFieldLayoutId(issueType.getId()))) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        i = 0;
        for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
            if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
            if (issueTypeScreenSchemeEntity == null) {
                issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
            }
            if (i == 0) {
                fieldScreenScheme = issueTypeScreenSchemeEntity.getFieldScreenScheme();
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        return new CheckIssueTypeAssociationsResult(true, workflow, fieldScreenScheme, fieldLayoutId);
    }

    private Collection<IssueType> getAlternativeTypes(IssueType currentIssueType, Collection<IssueType> issueTypes, Collection<Project> projects, JiraWorkflow jiraWorkflow, FieldScreenScheme fieldScreenScheme, Long fieldLayoutId) throws WorkflowException {
        IssueType issueType;
        HashSet<IssueType> availableIssueTypes = new HashSet<IssueType>();
        block0: for (IssueType potentialNewIssueType : issueTypes) {
            if (currentIssueType.getId().equals(potentialNewIssueType.getId())) continue;
            for (Project project : projects) {
                if (jiraWorkflow.equals(this.workflowManager.getWorkflow(project.getId(), potentialNewIssueType.getId()))) continue;
                continue block0;
            }
            availableIssueTypes.add(potentialNewIssueType);
        }
        Iterator iterator = availableIssueTypes.iterator();
        block2: while (iterator.hasNext()) {
            issueType = (IssueType)iterator.next();
            for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
                Long flid;
                if (fieldLayoutScheme.getProjects().isEmpty() || ObjectUtils.equalsNullSafe((Object)fieldLayoutId, (Object)(flid = fieldLayoutScheme.getFieldLayoutId(issueType.getId())))) continue;
                iterator.remove();
                continue block2;
            }
        }
        iterator = availableIssueTypes.iterator();
        block4: while (iterator.hasNext()) {
            issueType = (IssueType)iterator.next();
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
                if (issueTypeScreenSchemeEntity == null) {
                    issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
                }
                if (ObjectUtils.equalsNullSafe((Object)fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
                iterator.remove();
                continue block4;
            }
        }
        return availableIssueTypes;
    }

    private class CheckIssueTypeAssociationsResult {
        public boolean valid = false;
        public JiraWorkflow workflow = null;
        public FieldScreenScheme fieldScreenScheme;
        public Long fieldLayoutId;

        private CheckIssueTypeAssociationsResult(boolean valid, JiraWorkflow workflow, FieldScreenScheme fieldScreenScheme, Long fieldLayoutId) {
            this.valid = valid;
            this.workflow = workflow;
            this.fieldScreenScheme = fieldScreenScheme;
            this.fieldLayoutId = fieldLayoutId;
        }
    }
}

