/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;

public class JiraCacheManagerPeerProvider
extends RMICacheManagerPeerProvider {
    private static final RateLimitingLogger log = new RateLimitingLogger(JiraCacheManagerPeerProvider.class);
    private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);

    public JiraCacheManagerPeerProvider(CacheManager cacheManager) {
        super(cacheManager);
    }

    public void init() {
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public final void registerPeer(String rmiUrl) {
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        ArrayList<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
        if (!this.isContainerInitialized()) {
            return Collections.emptyList();
        }
        ClusterManager clusterManager = this.getClusterManager();
        final String currentNodeId = clusterManager.getNodeId();
        Collection<Node> liveNodes = clusterManager.findLiveNodes();
        Iterable nodesToPropagate = Iterables.filter(liveNodes, (Predicate)new Predicate<Node>(){

            public boolean apply(@Nullable Node node) {
                return node != null && !currentNodeId.equals(node.getNodeId());
            }
        });
        for (Node node : nodesToPropagate) {
            String rmiUrl = this.buildBaseUrl(node, cache.getName());
            try {
                remoteCachePeers.add(this.lookupRemoteCachePeer(rmiUrl));
            }
            catch (RemoteException e) {
                log.warn("Looking up rmiUrl " + rmiUrl + " threw a connection exception. This could mean that a node has gone offline " + " or it may indicate network connectivity difficulties. Details: " + e.getMessage());
            }
            catch (MalformedURLException e) {
                log.error("Looking up rmiUrl " + rmiUrl + " through exception . Urls are not well formed. Please fix this.");
            }
            catch (NotBoundException e) {
                log.debug("Looking up rmiUrl " + rmiUrl + " threw a connection exception. This may be normal if a node has gone offline." + " Or it may indicate network connectivity difficulties. Details : " + e.getMessage());
            }
        }
        return remoteCachePeers;
    }

    protected boolean stale(Date date) {
        return false;
    }

    private String buildBaseUrl(Node node, String cacheName) {
        return "//" + node.getIp() + ':' + node.getCacheListenerPort() + '/' + cacheName;
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.clusterManagerRef.get();
    }

    protected boolean isContainerInitialized() {
        return ComponentManager.getInstance().getState().isContainerInitialised();
    }
}

