/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.memory.MemoryCacheManager;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class LongExpireMemoryCacheManager
extends MemoryCacheManager {
    public static final int MAX_ENTRIES = 10000;

    protected ManagedCache createSimpleCache(@Nonnull String name, @Nonnull CacheSettings settings) {
        return super.createSimpleCache(name, this.overrideEviction(settings));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, CacheLoader<K, V> loader, @Nonnull CacheSettings settings) {
        return super.getCache(name, loader, this.overrideEviction(settings));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings settings) {
        return super.getCachedReference(owningClass, name, supplier, this.overrideEviction(settings));
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings settings) {
        return super.getCachedReference(name, supplier, this.overrideEviction(settings));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        return super.getCache(name);
    }

    private CacheSettings overrideEviction(CacheSettings settings) {
        CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder();
        cacheSettingsBuilder.expireAfterAccess(7L, TimeUnit.DAYS);
        cacheSettingsBuilder.expireAfterWrite(7L, TimeUnit.DAYS);
        if (settings == null) {
            cacheSettingsBuilder.maxEntries(10000);
            return cacheSettingsBuilder.build();
        }
        if (settings.getMaxEntries() == null) {
            cacheSettingsBuilder.maxEntries(10000);
        }
        CacheSettings overrideExpire = cacheSettingsBuilder.build();
        return settings.override(overrideExpire);
    }
}

