/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarImageDataStorage;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarServiceImpl;
import com.atlassian.jira.avatar.AvatarStore;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.avatar.ImageScaler;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarManagerImpl
implements AvatarManager {
    private static final Logger log = LoggerFactory.getLogger(AvatarManagerImpl.class);
    private static final String AVATAR_CLASSPATH_PREFIX = "/avatars/";
    private final AvatarStore store;
    private final JiraHome jiraHome;
    private final ApplicationProperties applicationProperties;
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final ImageScaler scaler;
    private final AvatarTagger avatarTagger;
    private final EventPublisher eventPublisher;
    private final AvatarImageDataStorage avatarImageDataStorage;

    public AvatarManagerImpl(AvatarStore store, JiraHome jiraHome, ApplicationProperties applicationProperties, GlobalPermissionManager globalPermissionManager, AvatarTagger avatarTagger, PermissionManager permissionManager, EventPublisher eventPublisher) {
        this(store, jiraHome, applicationProperties, globalPermissionManager, avatarTagger, new AvatarImageDataStorage(jiraHome, eventPublisher), permissionManager, eventPublisher);
    }

    public AvatarManagerImpl(AvatarStore store, JiraHome jiraHome, ApplicationProperties applicationProperties, GlobalPermissionManager globalPermissionManager, AvatarTagger avatarTagger, AvatarImageDataStorage avatarImageDataStorage, PermissionManager permissionManager, EventPublisher eventPublisher) {
        this.store = store;
        this.jiraHome = jiraHome;
        this.applicationProperties = applicationProperties;
        this.globalPermissionManager = globalPermissionManager;
        this.avatarTagger = avatarTagger;
        this.eventPublisher = eventPublisher;
        this.scaler = new ImageScaler();
        this.avatarImageDataStorage = avatarImageDataStorage;
        this.permissionManager = permissionManager;
    }

    public Avatar getById(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        return this.store.getById(avatarId);
    }

    public Avatar getByIdTagged(Long avatarId) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        return this.store.getByIdTagged(avatarId);
    }

    public boolean delete(Long avatarId) {
        return this.delete(avatarId, true);
    }

    public boolean delete(Long avatarId, boolean alsoDeleteAvatarFile) {
        Assertions.notNull((String)"avatarId", (Object)avatarId);
        Avatar avatar = this.store.getById(avatarId);
        if (avatar == null) {
            return false;
        }
        if (alsoDeleteAvatarFile) {
            AvatarManager.ImageSize[] imageSizes = AvatarManager.ImageSize.values();
            File[] avatarFiles = new File[imageSizes.length];
            for (int i = 0; i < imageSizes.length; ++i) {
                avatarFiles[i] = this.getAvatarFile(avatar, imageSizes[i].getFilenameFlag());
                this.deleteFile(avatarFiles[i]);
            }
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.AVATAR, avatarFiles));
        }
        return this.store.delete(avatarId);
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public void update(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"avatar.id", (Object)avatar.getId());
        this.store.update(avatar);
    }

    @Nonnull
    public Avatar create(Avatar avatar) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.stateTrue((String)"avatar.id must be null", (avatar.getId() == null ? 1 : 0) != 0);
        return this.store.create(avatar);
    }

    @Nonnull
    public Avatar create(Avatar avatar, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"avatar", (Object)avatar);
        if (avatar.isSystemAvatar()) {
            throw new IllegalArgumentException("System avatars cannot be created with custom image data");
        }
        Assertions.notNull((String)"imageData", (Object)imageData);
        File avatarFile = null;
        try {
            Avatar created = this.create(avatar);
            File largeAvatarFile = avatarFile = this.processImage(created, imageData, croppingSelection, AvatarManager.ImageSize.largest());
            for (AvatarManager.ImageSize size : AvatarManager.ImageSize.values()) {
                if (AvatarManager.ImageSize.largest().equals((Object)size)) continue;
                avatarFile = this.processImage(created, FileUtils.openInputStream((File)largeAvatarFile), null, size);
            }
            return created;
        }
        catch (RuntimeException failedCreate) {
            this.handleCreationFailure(avatarFile);
            throw failedCreate;
        }
    }

    @Nonnull
    public Avatar create(Avatar.Type avatarType, @Nonnull String owningObjectId, @Nonnull AvatarImageDataProvider imageDataProvider) throws IOException {
        Assertions.notNull((String)"avatarType", (Object)avatarType);
        Assertions.notNull((String)"owningObjectId", (Object)owningObjectId);
        Assertions.notNull((String)"imageDataProvider", (Object)imageDataProvider);
        AvatarImpl avatarStub = new AvatarImpl(null, this.avatarImageDataStorage.getNextFilenameStub() + ".png", "image/png", avatarType, owningObjectId, false);
        Avatar newAvatar = this.store.create(avatarStub);
        try {
            this.avatarImageDataStorage.storeAvatarFiles(newAvatar, imageDataProvider);
        }
        catch (IOException e) {
            this.store.delete(newAvatar.getId());
            throw e;
        }
        catch (RuntimeException e) {
            this.store.delete(newAvatar.getId());
            throw e;
        }
        return newAvatar;
    }

    @Nonnull
    public Avatar create(String fileName, String contentType, Project owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"avatar", (Object)contentType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        return this.create(AvatarImpl.createCustomAvatar(fileName, contentType, owner), imageData, croppingSelection);
    }

    @Nonnull
    public Avatar create(String fileName, String contentType, ApplicationUser owner, InputStream imageData, Selection croppingSelection) throws DataAccessException, IOException {
        Assertions.notNull((String)"fileName", (Object)fileName);
        Assertions.notNull((String)"avatar", (Object)contentType);
        Assertions.notNull((String)"owner", (Object)owner);
        Assertions.notNull((String)"imageData", (Object)imageData);
        return this.create(AvatarImpl.createCustomAvatar(fileName, owner), imageData, croppingSelection);
    }

    private void handleCreationFailure(File avatarFile) {
        try {
            if (avatarFile != null && avatarFile.exists() && !avatarFile.delete()) {
                log.warn("Created avatar file '" + avatarFile + "' but then failed to store to db. Failed to delete the file!");
            }
        }
        catch (RuntimeException failedDeleteFile) {
            log.warn("Created avatar file '" + avatarFile + "' but then failed to store to db. Failed to delete the file!", (Throwable)failedDeleteFile);
        }
    }

    File processImage(Avatar created, InputStream imageData, Selection croppingSelection, AvatarManager.ImageSize size) throws IOException {
        RenderedImage image = this.scaler.getSelectedImageData(new Thumber().getImage(imageData), croppingSelection, size.getPixels());
        File file = this.createAvatarFile(created, size.getFilenameFlag());
        this.avatarTagger.saveTaggedAvatar(image, AVATAR_IMAGE_FORMAT_FULL.getName(), file);
        this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.AVATAR, file));
        return file;
    }

    @VisibleForTesting
    File createAvatarFile(Avatar avatar, String flag) throws IOException {
        File base = this.getAvatarBaseDirectory();
        this.createDirectoryIfAbsent(base);
        return new File(base, avatar.getId() + "_" + flag + avatar.getFileName());
    }

    @Nonnull
    public File getAvatarBaseDirectory() {
        return new File(this.jiraHome.getHome(), "data/avatars");
    }

    private void createDirectoryIfAbsent(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Avatars directory is absent and I'm unable to create it. '" + dir.getAbsolutePath() + "'");
        }
        if (!dir.isDirectory()) {
            throw new IllegalStateException("Avatars directory cannot be created due to an existing file. '" + dir.getAbsolutePath() + "'");
        }
    }

    @Nonnull
    public List<Avatar> getAllSystemAvatars(Avatar.Type type) {
        try {
            return Lists.newArrayList((Iterable)Iterables.filter(this.store.getAllSystemAvatars(type), this.isUsableAvatarPredicate(type)));
        }
        catch (UnsupportedOperationException e) {
            return Lists.newArrayList();
        }
    }

    private Predicate<? super Avatar> isUsableAvatarPredicate(final Avatar.Type type) {
        return new Predicate<Avatar>(){

            public boolean apply(@Nullable Avatar input) {
                if (null == input) {
                    return false;
                }
                if (Avatar.Type.PROJECT.equals((Object)type)) {
                    return !Avatar.demotedSystemProjectAvatars.contains(input.getFileName());
                }
                return true;
            }
        };
    }

    @Nonnull
    public List<Avatar> getCustomAvatarsForOwner(Avatar.Type type, String ownerId) {
        return this.store.getCustomAvatarsForOwner(type, ownerId);
    }

    public boolean isAvatarOwner(Avatar avatar, String ownerId) {
        Assertions.notNull((String)"avatar", (Object)avatar);
        Assertions.notNull((String)"owner", (Object)ownerId);
        return this.getCustomAvatarsForOwner(avatar.getAvatarType(), ownerId).contains(avatar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAvatarData(Avatar avatar, Consumer<InputStream> dataAccessor, AvatarManager.ImageSize size) throws IOException {
        Option<Avatar> jiraAvatar = this.transformToJIRAAvatar(avatar);
        if (jiraAvatar.isDefined()) {
            InputStream data;
            if (((Avatar)jiraAvatar.get()).isSystemAvatar()) {
                String path = AVATAR_CLASSPATH_PREFIX + size.getFilenameFlag() + ((Avatar)jiraAvatar.get()).getFileName();
                data = this.getClasspathStream(path);
                if (data == null) {
                    log.error("System Avatar not found at the following resource path: " + path);
                    throw new IOException("File not found");
                }
            } else {
                File file = this.getOrGenerateAvatarFile((Avatar)jiraAvatar.get(), size);
                data = new FileInputStream(file);
            }
            try {
                dataAccessor.consume((Object)data);
            }
            finally {
                ((InputStream)data).close();
            }
        }
    }

    private Option<Avatar> transformToJIRAAvatar(Avatar avatar) {
        Option avatarId = Option.option((Object)avatar.getId());
        if (avatarId.isEmpty()) {
            return Option.none();
        }
        return Option.option((Object)this.getByIdTagged((Long)avatarId.get()));
    }

    private File getOrGenerateAvatarFile(Avatar avatar, AvatarManager.ImageSize size) throws IOException {
        File largeFile;
        File file = this.getAvatarFile(avatar, size.getFilenameFlag());
        if (!file.exists() && (largeFile = this.getOrGenerateLargerAvatarFile(avatar, size)) != null && largeFile.exists()) {
            return this.processImage(avatar, FileUtils.openInputStream((File)largeFile), null, size);
        }
        return file;
    }

    private File getOrGenerateLargerAvatarFile(Avatar avatar, AvatarManager.ImageSize sizeToGet) {
        File largestFileOnHand = null;
        File newFile = null;
        AvatarManager.ImageSize availableSize = null;
        for (Avatar.Size size : Avatar.Size.inPixelOrder()) {
            AvatarManager.ImageSize imageSize = AvatarManager.ImageSize.fromSize((Avatar.Size)size);
            File avatarFile = this.getAvatarFile(avatar, imageSize.getFilenameFlag());
            if (avatarFile.exists()) {
                largestFileOnHand = avatarFile;
                availableSize = imageSize;
            }
            if (null == availableSize || availableSize.getPixels() <= sizeToGet.getPixels()) continue;
            break;
        }
        try {
            if (largestFileOnHand != null) {
                newFile = this.processImage(avatar, FileUtils.openInputStream(largestFileOnHand), null, sizeToGet);
            }
        }
        catch (IOException ioe) {
            log.error(String.format("Failed to generate new image for '%s' from image '%s'", sizeToGet, largestFileOnHand), (Throwable)ioe);
        }
        return newFile != null ? newFile : (largestFileOnHand != null ? largestFileOnHand : null);
    }

    InputStream getClasspathStream(String path) {
        return AvatarManagerImpl.class.getResourceAsStream(path);
    }

    File getAvatarFile(Avatar avatar, String sizeFlag) {
        File base = this.getAvatarBaseDirectory();
        return new File(base, avatar.getId() + "_" + sizeFlag + avatar.getFileName());
    }

    public void readAvatarData(Avatar avatar, AvatarManager.ImageSize size, Consumer<InputStream> dataAccessor) throws IOException {
        this.processAvatarData(avatar, dataAccessor, size);
    }

    public Long getDefaultAvatarId(Avatar.Type ofType) {
        return ofType.getDefaultId(this.applicationProperties);
    }

    public Long getAnonymousAvatarId() {
        String avatarId = this.applicationProperties.getString("jira.avatar.user.anonymous.id");
        return avatarId != null ? Long.valueOf(avatarId) : null;
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, Avatar.Type type, String ownerId) {
        if (ownerId == null) {
            return type != Avatar.Type.PROJECT;
        }
        try {
            return type == Avatar.Type.PROJECT ? this.hasPermissionToView(AvatarServiceImpl.fromStaleUser(remoteUser), this.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(ownerId)))) : this.hasPermissionToView(AvatarServiceImpl.fromStaleUser(remoteUser), ApplicationUsers.byKey(ownerId));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, Project project) {
        if (project == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, remoteUser) || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, remoteUser);
    }

    public boolean hasPermissionToView(ApplicationUser remoteUser, ApplicationUser owner) {
        return owner == null || owner.equals((Object)remoteUser) || this.permissionManager.hasPermission(1, remoteUser);
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, Avatar.Type type, String ownerId) {
        if (ownerId == null) {
            return false;
        }
        try {
            if (type == Avatar.Type.PROJECT) {
                return this.hasPermissionToEdit(AvatarServiceImpl.fromStaleUser(remoteUser), this.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(ownerId))));
            }
            if (type == Avatar.Type.USER) {
                return this.hasPermissionToEdit(AvatarServiceImpl.fromStaleUser(remoteUser), ApplicationUsers.byKey(ownerId));
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, ApplicationUser owner) {
        if (Users.isAnonymous((ApplicationUser)remoteUser) || owner == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || remoteUser.getKey().equals(owner.getKey());
    }

    public boolean hasPermissionToEdit(ApplicationUser remoteUser, Project owner) {
        if (owner == null) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, remoteUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, owner, remoteUser);
    }

    ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }
}

