/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.association;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UserAssociationStoreImpl
implements UserAssociationStore {
    private final OfBizDelegator ofBizDelegator;
    private UserManager userManager;

    public UserAssociationStoreImpl(OfBizDelegator ofBizDelegator, UserManager userManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.userManager = userManager;
    }

    @Override
    public void createAssociation(String associationType, ApplicationUser user, GenericValue sink) {
        this.createAssociation(associationType, user.getKey(), sink.getEntityName(), sink.getLong("id"));
    }

    @Override
    public void createAssociation(String associationType, ApplicationUser user, Issue sink) {
        this.createAssociation(associationType, user.getKey(), "Issue", sink.getId());
    }

    @Override
    public void createAssociation(String associationType, String userName, String sinkNodeEntity, Long sinkNodeId) {
        GenericValue association = this.getAssociation(userName, sinkNodeId, sinkNodeEntity, associationType);
        if (association == null) {
            FieldMap fields = FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId).add("created", (Object)new Timestamp(System.currentTimeMillis()));
            GenericValue genericValue = this.ofBizDelegator.makeValue("UserAssociation");
            genericValue.setFields((Map)fields);
            try {
                genericValue.create();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    @Override
    public void removeAssociation(String associationType, String userkey, String sinkNodeEntity, Long sinkNodeId) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sinkNodeId", (Object)sinkNodeId);
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        fields.put((Object)"sourceName", (Object)userkey);
        fields.put((Object)"associationType", (Object)associationType);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public void removeAssociation(String associationType, ApplicationUser user, Issue sink) {
        this.removeAssociation(associationType, user.getKey(), "Issue", sink.getId());
    }

    @Override
    public void removeUserAssociationsFromUser(String associationType, ApplicationUser user, String sinkNodeEntity) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sourceName", (Object)user.getKey());
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public void removeUserAssociationsFromSink(String sinkNodeEntity, Long sinkNodeId) {
        FieldMap fields = new FieldMap();
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        fields.put((Object)"sinkNodeId", (Object)sinkNodeId);
        this.ofBizDelegator.removeByAnd("UserAssociation", (Map)fields);
    }

    @Override
    public boolean associationExists(String associationType, ApplicationUser user, String sinkNodeEntity, Long sinkNodeId) {
        return user != null && this.ofBizDelegator.findByAnd("UserAssociation", this.fieldMap(associationType, user.getKey(), sinkNodeEntity, sinkNodeId)).size() > 0;
    }

    @Override
    public List<ApplicationUser> getUsersFromSink(String associationType, GenericValue sink) {
        if (sink == null) {
            throw new IllegalArgumentException("Sink GenericValue can not be null.");
        }
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sink.getEntityName());
        fields.put((Object)"sinkNodeId", (Object)sink.getLong("id"));
        List<GenericValue> results = this.getAssociations((Map<String, ?>)fields);
        return (List)results.stream().map(result -> this.userManager.getUserByKeyEvenWhenUnknown(result.getString("sourceName"))).collect(CollectorsUtil.toNewArrayListWithSizeOf(results));
    }

    @Override
    public List<String> getUsernamesFromSink(String associationType, GenericValue sink) {
        List<ApplicationUser> users = this.getUsersFromSink(associationType, sink);
        ArrayList<String> usernames = new ArrayList<String>(users.size());
        usernames.addAll(users.stream().map(ApplicationUser::getUsername).collect(Collectors.toList()));
        return usernames;
    }

    @Override
    public Collection<String> getUserkeysFromSink(String associationType, String sinkNodeEntity, Long sinkNodeId) {
        if (sinkNodeEntity == null || sinkNodeId == null) {
            throw new IllegalArgumentException("Sink cannot be null.");
        }
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        fields.put((Object)"sinkNodeId", (Object)sinkNodeId);
        List<GenericValue> results = this.getAssociations((Map<String, ?>)fields);
        return (Collection)results.stream().map(result -> result.getString("sourceName")).collect(CollectorsUtil.toNewArrayListWithSizeOf(results));
    }

    @Override
    public Collection<String> getUserkeysFromIssue(String associationType, Long issueId) {
        return this.getUserkeysFromSink(associationType, "Issue", issueId);
    }

    @Override
    public List<GenericValue> getSinksFromUser(String associationType, ApplicationUser user, String sinkNodeEntity) {
        List<GenericValue> associations = this.getAssociationsForUser(associationType, user, sinkNodeEntity);
        ArrayList<GenericValue> sinks = new ArrayList<GenericValue>(associations.size());
        for (GenericValue association : associations) {
            GenericValue sink = this.ofBizDelegator.findByPrimaryKey(sinkNodeEntity, association.getLong("sinkNodeId"));
            if (sink == null) continue;
            sinks.add(sink);
        }
        return sinks;
    }

    private List<GenericValue> getAssociationsForUser(String associationType, ApplicationUser user, String sinkNodeEntity) {
        Assertions.notNull((String)"user", (Object)user);
        FieldMap fields = new FieldMap();
        fields.put((Object)"associationType", (Object)associationType);
        fields.put((Object)"sourceName", (Object)user.getKey());
        fields.put((Object)"sinkNodeEntity", (Object)sinkNodeEntity);
        return this.getAssociations((Map<String, ?>)fields);
    }

    private List<GenericValue> getAssociations(Map<String, ?> fields) {
        return this.ofBizDelegator.findByAnd("UserAssociation", fields);
    }

    private Map<String, ?> fieldMap(String associationType, String userName, String sinkNodeEntity, Long sinkNodeId) {
        return FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId);
    }

    private GenericValue getAssociation(String userName, Long sinkNodeId, String sinkNodeEntity, String associationType) {
        FieldMap fields = FieldMap.build((String)"associationType", (Object)associationType).add("sourceName", (Object)userName).add("sinkNodeEntity", (Object)sinkNodeEntity).add("sinkNodeId", (Object)sinkNodeId);
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("UserAssociation", (Map)fields));
    }
}

