/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.io.File;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import org.osgi.framework.Version;

@Nonnull
public class BundlesVersionDiscovery {
    PluginIdentification getBundleNameAndVersion(File jarFile) {
        JarPluginArtifact pluginArtifact = new JarPluginArtifact(jarFile);
        Manifest manifest = OsgiHeaderUtil.getManifest((PluginArtifact)pluginArtifact);
        return this.getBundleNameAndVersion(manifest);
    }

    PluginIdentification getBundleNameAndVersion(Manifest manifest) {
        PluginInformation pluginInformation = OsgiHeaderUtil.extractOsgiPluginInformation((Manifest)manifest, (boolean)true);
        String pluginKey = OsgiHeaderUtil.getAttributeWithoutValidation((Manifest)manifest, (String)"Bundle-SymbolicName");
        String version = pluginInformation.getVersion();
        return new PluginIdentification(pluginKey, version);
    }

    public static class PluginIdentification {
        private final String symbolicName;
        private final Version version;

        public PluginIdentification(String symbolicName, String version) {
            this.symbolicName = symbolicName;
            this.version = new Version(version);
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdentification that = (PluginIdentification)o;
            return this.symbolicName.equals(that.symbolicName) && this.version.equals((Object)that.version);
        }

        public int hashCode() {
            int result = this.symbolicName.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }
}

