/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowIssueStatusNull
extends CheckImpl {
    private final WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();
    private final ProjectManager projectManager = ComponentAccessor.getProjectManager();

    public WorkflowIssueStatusNull(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List<CheckAmendment> doCheck(boolean correct) throws IntegrityException {
        HashMap<String, ArrayList<Long>> statusKeysMap = new HashMap<String, ArrayList<Long>>();
        HashMap<String, Status> statusCache = new HashMap<String, Status>();
        try {
            List issueSteps = this.ofBizDelegator.findByAnd("IssueWorkflowStepView", (Map)FieldMap.build((String)"status", null));
            ArrayList results = Lists.newArrayListWithCapacity((int)issueSteps.size());
            for (GenericValue genericValue : issueSteps) {
                String issueKey = JiraKeyUtils.fastFormatIssueKey((String)this.projectManager.getProjectObj(genericValue.getLong("project")).getKey(), (Long)genericValue.getLong("issuenum"));
                try {
                    Status status = this.getStatusFromWorkflow(genericValue, statusCache);
                    String statusFromWorkflow = status.getId();
                    Long issueId = genericValue.getLong("issueid");
                    ArrayList<Long> issueIds = (ArrayList<Long>)statusKeysMap.get(statusFromWorkflow);
                    if (issueIds == null) {
                        issueIds = new ArrayList<Long>();
                        statusKeysMap.put(statusFromWorkflow, issueIds);
                    }
                    issueIds.add(issueId);
                    if (correct) {
                        results.add(new CheckAmendment(2, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.message", issueKey, status.getName()), "JRA-7428"));
                        continue;
                    }
                    results.add(new CheckAmendment(2, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.preview", issueKey, status.getName()), "JRA-7428"));
                }
                catch (IllegalStateException ise) {
                    results.add(new CheckAmendment(1, this.getI18NBean().getText("admin.integrity.check.workflow.issue.status.unfixable", issueKey, ise.getMessage()), "JRA-7428"));
                }
            }
            if (correct) {
                for (Object o : statusKeysMap.keySet()) {
                    String statusId = (String)o;
                    List issueIds = (List)statusKeysMap.get(statusId);
                    this.ofBizDelegator.bulkUpdateByPrimaryKey("Issue", (Map)FieldMap.build((String)"status", (Object)statusId), issueIds);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
    }

    private Status getStatusFromWorkflow(GenericValue genericValue, HashMap<String, Status> statusCache) throws WorkflowException, IllegalStateException {
        String issueType = genericValue.getString("type");
        Long projectId = genericValue.getLong("project");
        String cacheKey = projectId + ":" + issueType + ":" + genericValue.getInteger("stepId");
        Status status = statusCache.get(cacheKey);
        if (status == null) {
            JiraWorkflow workflow = this.workflowManager.getWorkflow(projectId, issueType);
            if (workflow == null) {
                throw new IllegalStateException("Workflow for project id " + projectId + " and issue type id " + issueType + " is not defined");
            }
            Integer stepId = genericValue.getInteger("stepId");
            if (stepId == null) {
                throw new IllegalStateException("Issue has no status, and status cannot be derived as the workflow step for this issue is missing.");
            }
            StepDescriptor step = workflow.getDescriptor().getStep(stepId.intValue());
            if (step == null) {
                throw new IllegalStateException("Can not resolve a step with id: " + stepId + " from workflow " + workflow.getName());
            }
            status = workflow.getLinkedStatusObject(step);
            if (status == null) {
                throw new IllegalStateException("Can not resolve a linked status for workflow step " + step.getName());
            }
            statusCache.put(cacheKey, status);
        }
        return status;
    }
}

