/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ajsmeta;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class GoogleSiteVerification {
    public static final String GOOGLE_SITE_VERIFICATION_KEY = "google.site.verification.key";
    private final ApplicationProperties applicationProperties;

    public GoogleSiteVerification(ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
    }

    private String getKey() {
        String propertyValue = this.applicationProperties.getString(GOOGLE_SITE_VERIFICATION_KEY);
        return StringUtils.isBlank((CharSequence)propertyValue) ? "" : propertyValue;
    }

    public void writeHtml(Writer writer) throws IOException {
        writer.write("<meta name=\"google-site-verification\"");
        writer.write(" content=\"");
        writer.write(TextUtils.htmlEncode((String)this.getKey()));
        writer.write("\">\n");
    }

    public boolean isAvailable() {
        return !StringUtils.isBlank((CharSequence)this.getKey());
    }
}

