/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.cache.AbstractCachingFilter;
import com.atlassian.core.filters.cache.CachingStrategy;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class JiraCachingFilter
extends AbstractCachingFilter {
    private static final CachingStrategy jiraCachingStrategy = new JiraCachingStrategy();
    private static final CachingStrategy iconCachingStrategy = new IconCachingStrategy();
    private static final CachingStrategy[] strategies = new CachingStrategy[]{jiraCachingStrategy, iconCachingStrategy};

    protected CachingStrategy[] getCachingStrategies() {
        return strategies;
    }

    static class JiraCachingStrategy
    implements CachingStrategy {
        private static final Set<String> nonCacheableUriSet = new HashSet<String>();

        JiraCachingStrategy() {
        }

        public boolean matches(HttpServletRequest request) {
            String servletPath = StringUtils.defaultString((String)request.getServletPath());
            if (request.isSecure() && servletPath.startsWith("/attachment")) {
                return false;
            }
            for (String nonCacheableUri : nonCacheableUriSet) {
                if (!servletPath.startsWith(nonCacheableUri)) continue;
                return true;
            }
            String uri = request.getRequestURI();
            return StringUtils.indexOf((String)uri, (String)".jsp") > 0;
        }

        public void setCachingHeaders(HttpServletResponse response) {
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }

        static {
            nonCacheableUriSet.add("/browse");
            nonCacheableUriSet.add("/issues");
        }
    }

    static class IconCachingStrategy
    implements CachingStrategy {
        private static final int ABOUT_ONE_YEAR = 31536000;

        IconCachingStrategy() {
        }

        public boolean matches(HttpServletRequest request) {
            String servletPath = StringUtils.defaultString((String)request.getServletPath());
            return servletPath.startsWith("/images/icons");
        }

        public void setCachingHeaders(HttpServletResponse response) {
            response.setHeader("Cache-Control", "max-age=31536000");
        }
    }
}

