/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.LicenseValidationResults;
import com.atlassian.jira.web.action.setup.SetupLicenseSessionStorage;
import com.google.common.collect.Lists;
import java.util.List;
import webwork.action.ActionContext;

public class SetupLicense
extends AbstractSetupAction {
    private static final String NEW_ACCOUNT = "newAccount";
    private static final String LOGIN = "login";
    private static final String EXISTING_LICENSE = "existingLicense";
    private static final String LICENSE_VALIDATION_RESULTS = "json";
    private final JiraLicenseUpdaterService licenseService;
    private final JiraSystemRestarter jiraSystemRestarter;
    private String licenseString;
    private String firstName;
    private String lastName;
    private String email;
    private JiraLicenseService.ValidationResult validationResult;
    private String licenseValidationJson;
    private String licenseToValidate;

    public SetupLicense(FileFactory fileFactory, JiraLicenseUpdaterService licenseService, JiraSystemRestarter jiraSystemRestarter, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.licenseService = licenseService;
        this.jiraSystemRestarter = jiraSystemRestarter;
    }

    public String doValidateLicense() {
        JiraLicenseService.ValidationResult validationResults = this.licenseService.validateApplicationLicense((I18nHelper)this, this.licenseToValidate);
        this.licenseValidationJson = new LicenseValidationResults(validationResults).toJson();
        if (validationResults.getErrorCollection().hasAnyErrors()) {
            ActionContext.getContext();
            ActionContext.getResponse().setStatus(403);
        }
        return LICENSE_VALIDATION_RESULTS;
    }

    public void doValidation() {
        this.validationResult = this.licenseService.validateApplicationLicense((I18nHelper)this, this.licenseString);
        ErrorCollection errorCollection = this.validationResult.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
        }
        super.doValidation();
    }

    protected String doExecute() {
        if (this.setupAlready()) {
            return "setupalready";
        }
        boolean licensePreviouslySet = this.licenseService.isLicenseSet();
        this.licenseService.setLicense(this.validationResult);
        if (!licensePreviouslySet) {
            this.jiraSystemRestarter.ariseSirJIRA();
        }
        this.request.getSession().setAttribute(SetupLicenseSessionStorage.SESSION_KEY, (Object)new SetupLicenseSessionStorage(this.firstName, this.lastName, this.email));
        return this.getRedirect("SetupAdminAccount!default.jspa");
    }

    public void setLicenseToValidate(String license) {
        this.licenseToValidate = license.replace(' ', '+');
    }

    public String getLicenseToValidate() {
        return this.licenseToValidate;
    }

    public String getLicenseValidationResults() {
        return this.licenseValidationJson;
    }

    public void setSetupLicenseKey(String licenseString) {
        this.licenseString = licenseString;
    }

    public void setSetupEmail(String email) {
        this.email = email;
    }

    public void setSetupFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setSetupLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<SetupOptions> getLicenseSetupOptions() {
        return Lists.newArrayList((Object[])new SetupOptions[]{new SetupOptions(NEW_ACCOUNT, this.getText("setupLicense.type.register")), new SetupOptions(LOGIN, this.getText("setupLicense.type.login")), new SetupOptions(EXISTING_LICENSE, this.getText("setup.cross.selling.license.option.existing.license"))});
    }

    private class SetupOptions {
        private final String key;
        private final String value;

        private SetupOptions(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

