/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@WebSudoRequired
public class ViewUser
extends IssueActionSupport {
    protected String name;
    protected ApplicationUser user;
    private boolean showPasswordUpdateMsg;
    private Map<String, String> userProperties;
    protected final CrowdService crowdService;
    protected final CrowdDirectoryService crowdDirectoryService;
    protected final UserPropertyManager userPropertyManager;
    protected final UserManager userManager;
    protected final FeatureManager featureManager;

    public ViewUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager, FeatureManager featureManager) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userPropertyManager = userPropertyManager;
        this.userManager = userManager;
        this.featureManager = featureManager;
    }

    public ViewUser(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        this(crowdService, crowdDirectoryService, userPropertyManager, userManager, (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationUser getUser() {
        return this.getApplicationUser();
    }

    public ApplicationUser getApplicationUser() {
        if (this.user == null) {
            this.user = this.userManager.getUserByName(this.getName());
        }
        return this.user;
    }

    public Collection<String> getUserGroups() {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(this.name).returningAtMost(-1);
        return Lists.newArrayList((Iterable)this.crowdService.search((Query)membershipQuery));
    }

    public String getDirectoryName() {
        ApplicationUser user = this.getApplicationUser();
        if (this.userManager.isUserExisting(user)) {
            return this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName();
        }
        return "???";
    }

    protected String doExecute() throws Exception {
        this.retrieveUserMetaProperties();
        return super.doExecute();
    }

    protected void doValidation() {
        if (this.getUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.users.user.does.not.exist"));
        }
    }

    protected void retrieveUserMetaProperties() {
        PropertySet userPropertySet;
        Collection keys;
        this.userProperties = new HashMap<String, String>();
        ApplicationUser user = this.getUser();
        if (user != null && (keys = (userPropertySet = this.userPropertyManager.getPropertySet(user)).getKeys(5)) != null) {
            for (String key : keys) {
                if (!key.startsWith("jira.meta.")) continue;
                this.userProperties.put(key.substring("jira.meta.".length()), userPropertySet.getString(key));
            }
        }
    }

    public boolean isShowPasswordUpdateMsg() {
        return this.showPasswordUpdateMsg;
    }

    public void setShowPasswordUpdateMsg(boolean showPasswordUpdateMsg) {
        this.showPasswordUpdateMsg = showPasswordUpdateMsg;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public boolean isRemoteUserPermittedToEditSelectedUser() {
        return this.getUser() != null && (this.isSystemAdministrator() || !this.getGlobalPermissionManager().hasPermission(44, this.getApplicationUser()));
    }

    public boolean isSelectedUserEditable() {
        if (this.userManager.canUpdateUser(this.getApplicationUser())) {
            return this.isRemoteUserPermittedToEditSelectedUser();
        }
        return false;
    }

    public boolean isSelectedUsersGroupsEditable() {
        return this.userManager.canUpdateGroupMembershipForUser(this.getUser());
    }

    public boolean canUpdateUserPassword() {
        return this.isSelectedUserEditable() && this.userManager.canUpdateUserPassword(this.getUser());
    }

    public boolean isOnDemand() {
        return this.featureManager.isOnDemand();
    }
}

