/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.resourcebundle;

import com.atlassian.jira.util.resourcebundle.ResourceBundleLoader;
import com.atlassian.jira.util.resourcebundle.ResourceLoaderInvocation;
import com.google.common.base.Supplier;
import java.util.Locale;

class DefaultResourceBundleLoader
implements ResourceBundleLoader {
    private final boolean i18n;
    private final Supplier<ResourceLoaderInvocation> invocationSupplier;
    private final Locale locale;

    DefaultResourceBundleLoader(Locale locale, boolean i18n, Supplier<ResourceLoaderInvocation> invocationSupplier) {
        this.locale = locale;
        this.i18n = i18n;
        this.invocationSupplier = invocationSupplier;
    }

    @Override
    public final ResourceBundleLoader locale(Locale locale) {
        if (this.locale.equals(locale)) {
            return this;
        }
        return new DefaultResourceBundleLoader(locale, this.i18n, this.invocationSupplier);
    }

    @Override
    public final ResourceBundleLoader helpText() {
        return this.setI18n(false);
    }

    @Override
    public final ResourceBundleLoader i18n() {
        return this.setI18n(true);
    }

    private ResourceBundleLoader setI18n(boolean i18n) {
        if (this.i18n == i18n) {
            return this;
        }
        return new DefaultResourceBundleLoader(this.locale, i18n, this.invocationSupplier);
    }

    @Override
    public final ResourceBundleLoader.LoadResult load() {
        ResourceLoaderInvocation invocation = ((ResourceLoaderInvocation)this.invocationSupplier.get()).locale(this.locale);
        invocation = this.i18n ? invocation.languages() : invocation.help();
        return invocation.load();
    }
}

