/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.history.ChangeItemBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class JiraEntityUtils {
    public static final Transformer GV_TO_ID_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            return ((GenericValue)object).getLong("id");
        }
    };
    public static final Transformer GENERIC_VALUE_TO_ID_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            GenericValue project = (GenericValue)object;
            return project.getLong("id");
        }
    };

    private JiraEntityUtils() {
    }

    public static Collection transforToIdsCollection(Collection genericValues) {
        return CollectionUtils.collect((Collection)genericValues, (Transformer)GENERIC_VALUE_TO_ID_TRANSFORMER);
    }

    public static List<ChangeItemBean> updateDependentEntitiesCheckId(GenericValue issue, Collection newEntities, String relationType, String changeItemField) throws GenericEntityException {
        if (newEntities == null) {
            newEntities = Collections.EMPTY_LIST;
        }
        ArrayList<ChangeItemBean> changes = new ArrayList<ChangeItemBean>(newEntities.size());
        List oldEntities = ComponentAccessor.getIssueManager().getEntitiesByIssue(relationType, issue);
        Collection oldEntityIds = CollectionUtils.collect((Collection)oldEntities, (Transformer)GV_TO_ID_TRANSFORMER);
        Collection newEntityIds = CollectionUtils.collect((Collection)newEntities, (Transformer)GV_TO_ID_TRANSFORMER);
        for (Object newEntity1 : newEntities) {
            GenericValue newEntity = (GenericValue)newEntity1;
            if (oldEntityIds.contains(newEntity.getLong("id"))) continue;
            JiraEntityUtils.getNodeAssociationStore().createAssociation(issue, newEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, newEntity.getLong("id").toString(), newEntity.getString("name")));
        }
        for (Object oldEntity1 : oldEntities) {
            GenericValue oldEntity = (GenericValue)oldEntity1;
            if (newEntityIds.contains(oldEntity.getLong("id"))) continue;
            JiraEntityUtils.getNodeAssociationStore().removeAssociation(issue, oldEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, oldEntity.getLong("id").toString(), oldEntity.getString("name"), null, null));
        }
        return changes;
    }

    public static List<ChangeItemBean> updateDependentEntities(GenericValue issue, Collection newEntities, String relationType, String changeItemField) throws GenericEntityException {
        if (newEntities == null) {
            newEntities = Collections.EMPTY_LIST;
        }
        ArrayList<ChangeItemBean> changes = new ArrayList<ChangeItemBean>(newEntities.size());
        List oldEntities = ComponentAccessor.getIssueManager().getEntitiesByIssue(relationType, issue);
        for (Object newEntity1 : newEntities) {
            GenericValue newEntity = (GenericValue)newEntity1;
            if (oldEntities.contains(newEntity)) continue;
            JiraEntityUtils.getNodeAssociationStore().createAssociation(issue, newEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, null, null, newEntity.getLong("id").toString(), newEntity.getString("name")));
        }
        for (Object oldEntity1 : oldEntities) {
            GenericValue oldEntity = (GenericValue)oldEntity1;
            if (newEntities.contains(oldEntity)) continue;
            JiraEntityUtils.getNodeAssociationStore().removeAssociation(issue, oldEntity, relationType);
            changes.add(new ChangeItemBean("jira", changeItemField, oldEntity.getLong("id").toString(), oldEntity.getString("name"), null, null));
        }
        return changes;
    }

    private static NodeAssociationStore getNodeAssociationStore() {
        return (NodeAssociationStore)ComponentAccessor.getComponent(NodeAssociationStore.class);
    }

    public static Map<Object, Object> createEntityMap(List<GenericValue> entities, String key, String value) {
        ListOrderedMap map = new ListOrderedMap();
        for (GenericValue gv : entities) {
            map.put(gv.get(key), gv.get(value));
        }
        return map;
    }
}

