/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.DowngradeUtilsImpl;
import java.sql.Timestamp;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildNumberDao {
    private static final String ENTITY_UPGRADE_VERSION_HISTORY = "UpgradeVersionHistory";
    private static final String FIELD_TIMEPERFORMED = "timeperformed";
    private static final String FIELD_TARGETBUILD = "targetbuild";
    private static final String FIELD_TARGETVERSION = "targetversion";
    private static final Logger log = LoggerFactory.getLogger(BuildNumberDao.class);
    private final BuildUtilsInfo buildUtilsInfo;
    private final DowngradeUtilsImpl downgradeUtilsInfo;
    private final ApplicationProperties applicationProperties;

    public BuildNumberDao(BuildUtilsInfo buildUtilsInfo, DowngradeUtilsImpl downgradeUtilsInfo, ApplicationProperties applicationProperties) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.downgradeUtilsInfo = downgradeUtilsInfo;
        this.applicationProperties = applicationProperties;
    }

    public void setJiraBuildNumber() {
        log.info("Setting current build number to " + this.buildUtilsInfo.getCurrentBuildNumber());
        this.applicationProperties.setString("jira.version.patched", this.buildUtilsInfo.getCurrentBuildNumber());
    }

    public void setJiraBuildNumber(String buildNumber) {
        log.info("Setting current build number to " + buildNumber);
        this.applicationProperties.setString("jira.version.patched", buildNumber);
    }

    public void setJiraVersion() {
        log.info("Setting current version to " + this.buildUtilsInfo.getVersion());
        this.applicationProperties.setString("jira.version", this.buildUtilsInfo.getVersion());
    }

    public void setMinimumDowngradeVersion() {
        log.info("Setting downgrade version to " + this.downgradeUtilsInfo.getDowngradeAllowedVersion());
        this.applicationProperties.setString("jira.downgrade.minimum.version", this.downgradeUtilsInfo.getDowngradeAllowedVersion());
    }

    public void insertUpgradeVersionHistory(OfBizDelegator ofBizDelegator) {
        String currentBuildNumber = this.buildUtilsInfo.getCurrentBuildNumber();
        GenericValue record = ofBizDelegator.findByPrimaryKey(ENTITY_UPGRADE_VERSION_HISTORY, (Map)FieldMap.build((String)FIELD_TARGETBUILD, (Object)currentBuildNumber));
        if (record == null) {
            Timestamp timePerformed = new Timestamp(System.currentTimeMillis());
            String version = this.buildUtilsInfo.getVersion();
            ofBizDelegator.createValue(ENTITY_UPGRADE_VERSION_HISTORY, (Map)FieldMap.build((String)FIELD_TIMEPERFORMED, (Object)timePerformed, (String)FIELD_TARGETBUILD, (Object)currentBuildNumber, (String)FIELD_TARGETVERSION, (Object)version));
        } else if (log.isDebugEnabled()) {
            log.debug("A record already exists for build number '" + currentBuildNumber + "' - skipping creation.");
        }
    }
}

