/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationChangedValue;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.UseBasedMigration;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class UseBasedMigrationImpl
extends UseBasedMigration {
    private final GlobalPermissionDao dao;

    UseBasedMigrationImpl(GlobalPermissionDao dao) {
        this.dao = (GlobalPermissionDao)Assertions.notNull((String)"dao", (Object)dao);
    }

    @Override
    MigrationState addUsePermissionToRoles(MigrationState state, Iterable<ApplicationKey> keys) {
        Assertions.notNull((String)"state", (Object)state);
        Assertions.notNull((String)"keys", keys);
        Set<Group> adminGroups = this.dao.groupsWithAdminPermission();
        Set<Group> useGroups = this.dao.groupsWithUsePermission();
        Sets.SetView allGroups = Sets.union(adminGroups, useGroups);
        Sets.SetView defaultGroups = Sets.difference(useGroups, adminGroups);
        MigrationState migratedState = state;
        for (ApplicationKey key : keys) {
            migratedState = migratedState.changeApplicationRole(key, arg_0 -> UseBasedMigrationImpl.lambda$addUsePermissionToRoles$41((Set)allGroups, (Set)defaultGroups, arg_0));
            List<ChangedValue> changedValues = this.getChangedValues((Set<Group>)allGroups, (Set<Group>)defaultGroups, key.value());
            AuditEntry auditEntry = new AuditEntry(UseBasedMigrationImpl.class, "Migrated groups to " + key.value() + ": " + allGroups.size(), changedValues, "Group with USE permission migrated to a role to ensure continued access for associated users.", key.value());
            migratedState = migratedState.log(auditEntry);
        }
        return migratedState;
    }

    private List<ChangedValue> getChangedValues(Set<Group> groups, Set<Group> defaultGroups, String role) {
        return groups.stream().map(group -> this.getMigrationChangedValue(role, (Group)group, defaultGroups)).collect(Collectors.toList());
    }

    private MigrationChangedValue getMigrationChangedValue(String role, Group group, Set<Group> defaultGroups) {
        String s = defaultGroups.contains(group) ? " (default)" : "";
        return new MigrationChangedValue(group.getName(), "USE", role + s);
    }

    private static /* synthetic */ ApplicationRole lambda$addUsePermissionToRoles$41(Set set, Set set2, ApplicationRole role) {
        return role.addGroups(set).addGroupsAsDefault(set2);
    }
}

