/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseDao;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.util.dbc.Assertions;

final class Move6xLicenseTo70Store
extends MigrationTask {
    private final LicenseDao dao;

    Move6xLicenseTo70Store(LicenseDao dao) {
        this.dao = (LicenseDao)Assertions.notNull((String)"dao", (Object)dao);
    }

    @Override
    MigrationState migrate(MigrationState state) {
        Option<License> oldLicense;
        if ((state = state.withAfterSaveTask(this.dao::remove6xLicense)).licenses().isEmpty() && (oldLicense = this.dao.get6xLicense()).isDefined()) {
            License license = (License)oldLicense.get();
            MigrationState loggedMigrationState = state.log(new AuditEntry(Move6xLicenseTo70Store.class, "Moved license location", null, "Moved license from old location in application properties to new location in license table", license.getSEN(), AssociatedItem.Type.LICENSE));
            return loggedMigrationState.changeLicenses(licenses -> licenses.addLicense(license));
        }
        return state.log(new AuditEntry(Move6xLicenseTo70Store.class, "Not moving license location", "License will not be migrated as there is an existing license."));
    }
}

