/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.GlobalPermissionDao;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.upgrade.tasks.role.MigrationChangedValue;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class Move6xAdminPermissionOverToLicensedApplication
extends MigrationTask {
    private final GlobalPermissionDao permissionDao;

    Move6xAdminPermissionOverToLicensedApplication(GlobalPermissionDao permissionDao) {
        this.permissionDao = (GlobalPermissionDao)Assertions.notNull((String)"permissionDao", (Object)permissionDao);
    }

    @Override
    MigrationState migrate(MigrationState state) {
        Multimap<Group, GlobalPermissionDao.AdminPermission> adminGroups = this.permissionDao.groupsWithAdminPermissionAndPermissionType();
        if (adminGroups == null || adminGroups.isEmpty()) {
            return state.log(new AuditEntry(this.getClass(), "No admin groups to migrate.", null, "Admin groups will usually be migrated to an application so that they retain permission as regular users.", null));
        }
        Option<ApplicationKey> adminApplication = this.getAdminApplication(state.licenses());
        if (adminApplication.isEmpty()) {
            return state.log(new AuditEntry(this.getClass(), "No application found for admin.", "Admin groups will usually be migrated to an application so that they retain permission as regular users."));
        }
        ApplicationKey key = (ApplicationKey)adminApplication.get();
        MigrationState migrationState = state.changeApplicationRole(key, role -> role.addGroups(adminGroups.keySet()));
        String summary = "Administrator groups migrated to " + key.value() + ": " + adminGroups.size();
        List<ChangedValue> changedValues = this.getChangedValues(adminGroups, key);
        AuditEntry auditEntry = new AuditEntry(Move6xAdminPermissionOverToLicensedApplication.class, summary, changedValues, "Admin groups are migrated to an application so administrators can continue to use all the functionality they used to be able to.", key.value());
        return migrationState.log(auditEntry);
    }

    private List<ChangedValue> getChangedValues(Multimap<Group, GlobalPermissionDao.AdminPermission> adminGroups, ApplicationKey key) {
        return adminGroups.asMap().entrySet().stream().map(entry -> this.getMigrationChangedValue(key, (Map.Entry<Group, Collection<GlobalPermissionDao.AdminPermission>>)entry)).collect(Collectors.toList());
    }

    private MigrationChangedValue getMigrationChangedValue(ApplicationKey key, Map.Entry<Group, Collection<GlobalPermissionDao.AdminPermission>> group) {
        String permissions = String.join((CharSequence)", ", group.getValue().stream().map(Object::toString).collect(Collectors.toSet()));
        return new MigrationChangedValue(group.getKey().getName(), permissions, permissions + ", " + key.value());
    }

    private Option<ApplicationKey> getAdminApplication(Licenses licenses) {
        Set<ApplicationKey> appKeys = licenses.keys();
        if (appKeys.contains(ApplicationKeys.CORE)) {
            return Option.some((Object)ApplicationKeys.CORE);
        }
        if (appKeys.contains(ApplicationKeys.SOFTWARE)) {
            return Option.some((Object)ApplicationKeys.SOFTWARE);
        }
        if (!appKeys.isEmpty()) {
            return Option.some((Object)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).onResultOf(ApplicationKey::value).min(appKeys));
        }
        return Option.none();
    }
}

