/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build642
extends LegacyImmediateUpgradeTask {
    private static final String JIRA_OPTION_RPC_ALLOW = "jira.option.rpc.allow";
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build642.class);
    private final ApplicationProperties applicationProperties;

    public UpgradeTask_Build642(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getBuildNumber() {
        return "642";
    }

    @Override
    public String getShortDescription() {
        return "Turn AllowRPC On for new installations only.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        boolean allowRpc = setupMode ? true : this.applicationProperties.getOption(JIRA_OPTION_RPC_ALLOW);
        this.applicationProperties.setOption(JIRA_OPTION_RPC_ALLOW, allowRpc);
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "640";
    }
}

