/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.atlassian.jira.upgrade.util.UpgradeEntityUtil;
import com.atlassian.jira.util.Visitor;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6321
extends LegacyImmediateUpgradeTask {
    public static final String SCHEME_PERMISSIONS_TABLE = "SchemePermissions";
    public static final String PERMISSION_PARAMETER = "permission";
    public static final String ID_PARAMETER = "id";
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6321.class);

    @Override
    public String getBuildNumber() {
        return "6321";
    }

    @Override
    public String getShortDescription() {
        return "Grants Transition permission to all users with Browse permission";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        final long permissionToCopy = setupMode ? 12L : 10L;
        final UpgradeEntityUtil upgradeEntityUtil = new UpgradeEntityUtil("UpgradeTask_Build6321", UpgradeTask_Build6321.getEntityEngine());
        upgradeEntityUtil.deleteEntityByCondition(SCHEME_PERMISSIONS_TABLE, (EntityCondition)new EntityExpr(PERMISSION_PARAMETER, EntityOperator.EQUALS, (Object)46L));
        Select.from(SCHEME_PERMISSIONS_TABLE).whereEqual(PERMISSION_PARAMETER, permissionToCopy).runWith(UpgradeTask_Build6321.getEntityEngine()).visitWith(new Visitor<GenericValue>(){

            public void visit(GenericValue schemePermission) {
                GenericValue transitionPermission = (GenericValue)schemePermission.clone();
                transitionPermission.set(UpgradeTask_Build6321.PERMISSION_PARAMETER, (Object)46L);
                transitionPermission.set(UpgradeTask_Build6321.ID_PARAMETER, null);
                try {
                    UpgradeTask_Build6321.getOfBizDelegator().createValue(UpgradeTask_Build6321.SCHEME_PERMISSIONS_TABLE, (Map)transitionPermission);
                }
                catch (DataAccessException e) {
                    upgradeEntityUtil.logEntity(UpgradeTask_Build6321.SCHEME_PERMISSIONS_TABLE, schemePermission, "MIGRATE FAIL");
                    log.error("Problem while migrating to " + Permissions.getShortName((int)((int)permissionToCopy)) + " to TRANSITION_ISSUE permission", (Throwable)e);
                }
            }
        });
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6320";
    }
}

