/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6045
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6045.class);
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final GenericConfigManager genericConfigManager;

    public UpgradeTask_Build6045(CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, GenericConfigManager genericConfigManager) {
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    public String getBuildNumber() {
        return "6045";
    }

    @Override
    public String getShortDescription() {
        return "Converting default Custom field values for User and MultiUser types to store the key of the user rather than the username.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List<CustomField> customFieldList = this.getCustomFields();
        int i = 0;
        for (CustomField customField : customFieldList) {
            log.info("Updating custom field '" + customField.getName() + "', " + ++i + " of " + customFieldList.size());
            this.processCustomFieldDefaults(customField);
        }
    }

    private void processCustomFieldDefaults(CustomField customField) {
        HashSet<Long> configIds = new HashSet<Long>();
        List fieldConfigSchemes = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField);
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            Map configs = fieldConfigScheme.getConfigs();
            for (FieldConfig fieldConfig : configs.values()) {
                configIds.add(fieldConfig.getId());
            }
        }
        for (Long configId : configIds) {
            Object defaultObject = this.genericConfigManager.retrieve("DefaultValue", configId.toString());
            if (defaultObject == null) continue;
            if (defaultObject instanceof Collection) {
                HashSet defaultIds = Sets.newHashSet();
                Collection defaultsFromDb = (Collection)defaultObject;
                for (Object aDefault : defaultsFromDb) {
                    if (!(aDefault instanceof String)) continue;
                    defaultIds.add(IdentifierUtils.toLowerCase((String)((String)aDefault)));
                }
                this.genericConfigManager.update("DefaultValue", configId.toString(), (Object)defaultIds);
                continue;
            }
            if (defaultObject instanceof String) {
                String aDefault = (String)defaultObject;
                if (aDefault == null) continue;
                this.genericConfigManager.update("DefaultValue", configId.toString(), (Object)IdentifierUtils.toLowerCase((String)aDefault));
                continue;
            }
            this.genericConfigManager.remove("DefaultValue", configId.toString());
        }
    }

    private List<CustomField> getCustomFields() {
        ArrayList userCustomFields = Lists.newArrayList();
        List allCustomFields = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : allCustomFields) {
            CustomFieldType type = customField.getCustomFieldType();
            if (!(type instanceof UserCFType) && !(type instanceof MultiUserCFType)) continue;
            userCustomFields.add(customField);
        }
        return userCustomFields;
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6044";
    }
}

