/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.dbc.Assertions;

public class ScalingTaskProgessSink
implements TaskProgressSink {
    private final long virtualStart;
    private final long virtualEnd;
    private final long actualStart;
    private final long actualEnd;
    private final double scale;
    private final TaskProgressSink delegateSink;

    public ScalingTaskProgessSink(long actualStart, long actualEnd, long virtualStart, long virtualEnd, TaskProgressSink delegateSink) {
        Assertions.notNull((String)"delegateSink", (Object)delegateSink);
        Assertions.not((String)"virtualEnd should be >= virtualStart.", (virtualStart > virtualEnd ? 1 : 0) != 0);
        Assertions.not((String)"actualEnd should be >= actualStart.", (actualStart > actualEnd ? 1 : 0) != 0);
        this.delegateSink = delegateSink;
        this.virtualStart = virtualStart;
        this.virtualEnd = virtualEnd;
        this.actualStart = actualStart;
        this.actualEnd = actualEnd;
        this.scale = actualEnd != actualStart ? (double)(actualEnd - actualStart) / (double)(virtualEnd - virtualStart) : 0.0;
    }

    public ScalingTaskProgessSink(long actualStart, long actualEnd, TaskProgressSink delegateSink) {
        this(actualStart, actualEnd, 0L, 100L, delegateSink);
    }

    public void makeProgress(long taskProgress, String currentSubTask, String message) {
        if (taskProgress < this.virtualStart) {
            taskProgress = this.virtualStart;
        } else if (taskProgress > this.virtualEnd) {
            taskProgress = this.virtualEnd;
        }
        if (taskProgress == this.virtualEnd) {
            this.delegateSink.makeProgress(this.actualEnd, currentSubTask, message);
        } else {
            double actualProgress = taskProgress - this.virtualStart;
            actualProgress = actualProgress * this.scale + (double)this.actualStart;
            this.delegateSink.makeProgress(Math.min(Math.round(actualProgress), this.actualEnd), currentSubTask, message);
        }
    }
}

