/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.BootstrappingStartupState;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.StartupStateTemplate;
import com.atlassian.jira.startup.SystemPluginsEnabledStartupCheck;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicReference;

public class RunningStartupState
extends StartupStateTemplate
implements JiraStartupState {
    private static final ImmutableList<StartupCheck> STARTUP_CHECKS = ImmutableList.of((Object)new SystemPluginsEnabledStartupCheck());
    private final BootstrappingStartupState bootstrapping;
    private final AtomicReference<JiraStartupState> currentState;

    public RunningStartupState(BootstrappingStartupState bootstrapping, AtomicReference<JiraStartupState> currentState) {
        this.bootstrapping = bootstrapping;
        this.currentState = currentState;
    }

    @Override
    public boolean isStartupChecksPassed() {
        return this.bootstrapping.isStartupChecksPassed() && super.isStartupChecksPassed();
    }

    @Override
    public void onPluginSystemStarted() throws IllegalStateException {
        throw new IllegalStateException("onPluginSystemStarted called twice");
    }

    @Override
    public void onPluginSystemDelayed() throws IllegalStateException {
        throw new IllegalStateException("onPluginSystemDelayed() called after onPluginStarted()");
    }

    @Override
    public StartupCheck getFailedStartupCheck() {
        StartupCheck failedBootstrappingcheck = this.bootstrapping.getFailedStartupCheck();
        if (failedBootstrappingcheck != null) {
            return failedBootstrappingcheck;
        }
        return super.getFailedStartupCheck();
    }

    @Override
    public void setFailedStartupCheck(StartupCheck startupCheck) {
        this.bootstrapping.setFailedStartupCheck(startupCheck);
    }

    @Override
    public void onPluginSystemStopped() {
        this.currentState.set(new BootstrappingStartupState(this.currentState));
    }

    @Override
    public void onPluginSystemRestarted() {
        this.currentState.set(new RunningStartupState(this.bootstrapping, this.currentState));
    }

    @Override
    public void onJiraStopping() {
        this.bootstrapping.onJiraStopping();
    }

    @Override
    protected ImmutableList<StartupCheck> getStartupChecks() {
        return STARTUP_CHECKS;
    }
}

