/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.database.DatabaseDriverRegisterer;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.config.webwork.WebworkConfigurator;
import com.atlassian.jira.startup.FailedStartupCheck;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapContainerLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(BootstrapContainerLauncher.class);

    @Override
    public void start() {
        try {
            this.bootstrapJIRA();
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during BootstrapContainerLauncher servlet context initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during BootstrapContainerLauncher servlet context initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    private void bootstrapJIRA() {
        try {
            ComponentManager.getInstance().bootstrapInitialise();
            if (JiraStartupChecklist.startupOK()) {
                DatabaseConfigurationManager dbcm = (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class);
                if (!dbcm.isDatabaseSetup()) {
                    this.bootstrapJIRAWhenDBIsNotSetup(dbcm);
                }
            } else {
                this.bootstrapJIRAWhenStartupChecksFail();
            }
        }
        catch (Exception ex) {
            log.error("A fatal error occurred during bootstrapping. JIRA has been locked.", (Throwable)ex);
            String message = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
            JiraStartupChecklist.setFailedStartupCheck(new FailedStartupCheck("Component Manager", message));
        }
    }

    private void bootstrapJIRAWhenDBIsNotSetup(DatabaseConfigurationManager dbcm) {
        block3: {
            ComponentManager.getInstance().setupInitialise();
            try {
                dbcm.getDatabaseConfiguration();
            }
            catch (InvalidDatabaseDriverException e) {
                String errorMessage = this.getErrorMessageForDatabase(e);
                JiraStartupChecklist.setFailedStartupCheck(new FailedStartupCheck("Database Driver Check", errorMessage));
                return;
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof FileNotFoundException)) break block3;
                dbcm.createDbConfigFromEntityDefinition();
            }
        }
        ComponentManager.getInstance().start();
        WebworkConfigurator.setupConfiguration();
    }

    private void bootstrapJIRAWhenStartupChecksFail() {
        ComponentManager.getInstance().extendBootstrapContainerForFailedStartup();
    }

    @Override
    public void stop() {
    }

    private String getErrorMessageForDatabase(InvalidDatabaseDriverException e) {
        DatabaseDriverRegisterer registrar = DatabaseDriverRegisterer.forType(DatabaseType.forJdbcDriverClassName(e.driverClassName()));
        StringBuilder errorMessage = new StringBuilder("");
        if (registrar != null) {
            for (String s : registrar.getErrorMessage()) {
                errorMessage.append(s);
                errorMessage.append("\n");
            }
        } else {
            errorMessage.append(e.getMessage());
        }
        return errorMessage.toString();
    }
}

