/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.config.util.EncodingConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.sharing.type.VelocityShareTypeRenderer;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class GroupShareTypeRenderer
extends VelocityShareTypeRenderer {
    private static final String GROUPS_KEY = "groups";
    private static final String BOLD_START = "<b>";
    private static final String BOLD_END = "</b>";
    private final GroupManager groupManager;

    public GroupShareTypeRenderer(EncodingConfiguration encoding, VelocityTemplatingEngine templatingEngine, GroupManager groupManager) {
        super(encoding, templatingEngine);
        this.groupManager = groupManager;
    }

    public String renderPermission(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GroupShareType.TYPE, (Object)permission.getType());
        String groupName = TextUtils.htmlEncode((String)permission.getParam1());
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.group", BOLD_START, BOLD_END, groupName);
    }

    public String getSimpleDescription(SharePermission permission, JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.equals((String)"permission-type", (Object)GroupShareType.TYPE, (Object)permission.getType());
        String groupName = TextUtils.htmlEncode((String)permission.getParam1());
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.display.group.desc", groupName);
    }

    public String getShareTypeEditor(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> groups = new ArrayList<String>(this.getGroupsForUser(authenticationContext.getUser()));
        Collections.sort(groups);
        params.put(GROUPS_KEY, groups);
        return this.renderVelocity("share-type-group-selector.vm", params, authenticationContext);
    }

    public boolean isAddButtonNeeded(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return !this.getGroupsForUser(authenticationContext.getUser()).isEmpty();
    }

    public String getShareTypeLabel(JiraAuthenticationContext authenticationContext) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        return authenticationContext.getI18nHelper().getText("common.sharing.shared.description.group");
    }

    public Map<String, String> getTranslatedTemplates(JiraAuthenticationContext authenticationContext, SharedEntity.TypeDescriptor<? extends SharedEntity> type, ShareTypeRenderer.RenderMode mode) {
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.notNull((String)"type", type);
        Assertions.notNull((String)"mode", (Object)mode);
        HashMap<String, String> templates = new HashMap<String, String>();
        if (mode == ShareTypeRenderer.RenderMode.EDIT) {
            templates.put("share_group_display", StringEscapeUtils.escapeJavaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.group", BOLD_START, BOLD_END)));
            templates.put("share_group_description", StringEscapeUtils.escapeJavaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.shared.template.group.desc")));
        } else if (mode == ShareTypeRenderer.RenderMode.SEARCH) {
            templates.put("share_group_description", StringEscapeUtils.escapeJavaScript((String)authenticationContext.getI18nHelper().getText("common.sharing.search.template.group.desc." + type.getName())));
        }
        return Collections.unmodifiableMap(templates);
    }

    List<String> getGroupsForUser(ApplicationUser user) {
        if (user == null) {
            return Collections.emptyList();
        }
        Collection groupNames = this.groupManager.getGroupNamesForUser(user);
        return new ArrayList<String>(groupNames);
    }
}

