/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.util;

import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.util.AbstractGroupMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupToIssueSecuritySchemeMapper
extends AbstractGroupMapper {
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    public GroupToIssueSecuritySchemeMapper(IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.setGroupMapping(this.init());
    }

    private Map<String, Set<Scheme>> init() {
        HashMap<String, Set<Scheme>> mapping = new HashMap<String, Set<Scheme>>();
        List schemes = this.issueSecuritySchemeManager.getSchemeObjects();
        for (Scheme issueSecurityScheme : schemes) {
            Collection entities = issueSecurityScheme.getEntities();
            for (SchemeEntity entity : entities) {
                if (!"group".equals(entity.getType())) continue;
                this.addEntry(mapping, entity.getParameter(), issueSecurityScheme);
            }
        }
        return mapping;
    }
}

