/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.plugin.permission.GlobalPermissionModuleDescriptor;
import com.atlassian.jira.security.plugin.GlobalPermissionTypesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@EventComponent
public class GlobalPermissionTypesManagerImpl
implements Startable,
GlobalPermissionTypesManager {
    private final DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> pluginModuleTracker;
    private final ResettableLazyReference<Map<String, GlobalPermissionType>> globalPermissions;

    public GlobalPermissionTypesManagerImpl(@Nonnull PluginAccessor pluginAccessor, @Nonnull PluginEventManager pluginEventManager, @Nonnull ApplicationRoleManager applicationRoleManager) {
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, GlobalPermissionModuleDescriptor.class, (PluginModuleTracker.Customizer)new PluginModuleTracker.Customizer<Void, GlobalPermissionModuleDescriptor>(){

            public void removed(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
            }

            public GlobalPermissionModuleDescriptor adding(GlobalPermissionModuleDescriptor descriptor) {
                GlobalPermissionTypesManagerImpl.this.globalPermissions.reset();
                return descriptor;
            }
        });
        this.globalPermissions = new GlobalPermissionsResettableLazyReference(this.pluginModuleTracker.getModuleDescriptors(), applicationRoleManager);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.globalPermissions.reset();
    }

    @EventListener
    public void onFeatureChange(FeatureEvent event) {
        if (CoreFeatures.forFeatureKey((String)event.feature()) == CoreFeatures.LICENSE_ROLES_ENABLED) {
            this.globalPermissions.reset();
        }
    }

    public void start() throws Exception {
        this.globalPermissions.reset();
    }

    @Override
    public Collection<GlobalPermissionType> getAll() {
        return ((Map)this.globalPermissions.get()).values();
    }

    @Override
    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull String permissionKey) {
        return Option.option(((Map)this.globalPermissions.get()).get(permissionKey));
    }

    @Override
    public Option<GlobalPermissionType> getGlobalPermission(@Nonnull GlobalPermissionKey permissionKey) {
        return this.getGlobalPermission(permissionKey.getKey());
    }

    @VisibleForTesting
    DefaultPluginModuleTracker<Void, GlobalPermissionModuleDescriptor> getPluginModuleTracker() {
        return this.pluginModuleTracker;
    }

    private static class GlobalPermissionsResettableLazyReference
    extends ResettableLazyReference<Map<String, GlobalPermissionType>> {
        private final Iterable<GlobalPermissionModuleDescriptor> moduleDescriptors;
        private final ApplicationRoleManager applicationRoleManager;

        private GlobalPermissionsResettableLazyReference(Iterable<GlobalPermissionModuleDescriptor> moduleDescriptors, ApplicationRoleManager applicationRoleManager) {
            this.moduleDescriptors = moduleDescriptors;
            this.applicationRoleManager = applicationRoleManager;
        }

        protected Map<String, GlobalPermissionType> create() {
            HashMap permissions = Maps.newHashMap();
            for (GlobalPermissionModuleDescriptor moduleDescriptor : this.moduleDescriptors) {
                GlobalPermissionType globalPermissionType = this.createGlobalPermission(moduleDescriptor);
                String key = moduleDescriptor.getKey();
                if (!this.shouldAddPermission(key)) continue;
                permissions.put(key, globalPermissionType);
            }
            return permissions;
        }

        private boolean shouldAddPermission(String key) {
            return !this.applicationRoleManager.rolesEnabled() || !GlobalPermissionKey.USE.getKey().equals(key);
        }

        private GlobalPermissionType createGlobalPermission(GlobalPermissionModuleDescriptor descriptor) {
            return new GlobalPermissionType(descriptor.getKey(), descriptor.getI18nNameKey(), descriptor.getDescriptionI18nKey(), descriptor.isAnonymousAllowed());
        }
    }
}

