/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.auth.trustedapps.SimpleTrustedApplication;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collections;
import java.util.Set;

public class DefaultTrustedApplicationService
implements TrustedApplicationService {
    private final TrustedApplicationManager manager;
    private final PermissionCheck permissionCheck;
    private final TrustedApplicationValidator validator;

    public DefaultTrustedApplicationService(TrustedApplicationManager manager, final GlobalPermissionManager permissionManager, TrustedApplicationValidator validator) {
        this(manager, new PermissionCheck(){

            @Override
            public boolean check(ApplicationUser user) {
                return permissionManager.hasPermission(44, user);
            }
        }, validator);
    }

    DefaultTrustedApplicationService(TrustedApplicationManager manager, PermissionCheck permissionCheck, TrustedApplicationValidator validator) {
        Null.not("manager", manager);
        Null.not("permissionCheck", permissionCheck);
        Null.not("validator", validator);
        this.manager = manager;
        this.permissionCheck = permissionCheck;
        this.validator = validator;
    }

    @Override
    public Set<TrustedApplicationInfo> getAll(JiraServiceContext context) {
        if (this.notAllowed(context, "admin.errors.trustedapps.no.permission")) {
            return Collections.emptySet();
        }
        return this.manager.getAll();
    }

    @Override
    public TrustedApplicationInfo get(JiraServiceContext context, String applicationId) {
        if (this.notAllowed(context, "admin.errors.trustedapps.no.permission")) {
            return null;
        }
        return this.manager.get(applicationId);
    }

    @Override
    public TrustedApplicationInfo get(JiraServiceContext context, long id) {
        if (this.notAllowed(context, "admin.errors.trustedapps.no.permission")) {
            return null;
        }
        return this.manager.get(id);
    }

    @Override
    public boolean delete(JiraServiceContext context, long id) {
        return !this.notAllowed(context, "admin.errors.trustedapps.no.permission") && this.manager.delete(context.getLoggedInUser(), id);
    }

    @Override
    public TrustedApplicationInfo store(JiraServiceContext context, TrustedApplicationInfo info) {
        if (this.notAllowed(context, "admin.errors.trustedapps.no.permission")) {
            return null;
        }
        SimpleTrustedApplication application = new TrustedApplicationBuilder().set(info).toSimple();
        if (!this.validate(context, application)) {
            throw new IllegalArgumentException("Invalid TrustedApplication: " + context.getErrorCollection().getErrorMessages());
        }
        return this.manager.store(context.getLoggedInUser(), info);
    }

    @Override
    public boolean validate(JiraServiceContext jiraServiceContext, SimpleTrustedApplication builder) {
        if (this.notAllowed(jiraServiceContext, "admin.errors.trustedapps.no.permission")) {
            return false;
        }
        I18nHelper helper = jiraServiceContext.getI18nBean();
        return this.validator.validate(jiraServiceContext, helper, builder);
    }

    private boolean notAllowed(JiraServiceContext context, String errorMessageKey) {
        boolean notAllowed;
        boolean bl = notAllowed = !this.permissionCheck.check(context.getLoggedInUser());
        if (notAllowed) {
            context.getErrorCollection().addErrorMessage(context.getI18nBean().getText(errorMessageKey));
        }
        return notAllowed;
    }

    static interface PermissionCheck {
        public boolean check(ApplicationUser var1);
    }

    private static final class Keys {
        static final String NO_PERMISSION = "admin.errors.trustedapps.no.permission";

        private Keys() {
        }
    }
}

