/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.util.SecurityTypeUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.notification.SchemeAware;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSchemeAwareAction
extends JiraWebActionSupport
implements SchemeAware {
    private Long schemeId;
    private GenericValue scheme;
    private Scheme schemeObject;

    public abstract SchemeManager getSchemeManager();

    public abstract String getRedirectURL() throws GenericEntityException;

    @Override
    public Long getSchemeId() {
        return this.schemeId;
    }

    @Override
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    @Override
    public GenericValue getScheme() throws GenericEntityException {
        if (this.scheme == null) {
            this.scheme = this.getSchemeManager().getScheme(this.schemeId);
            this.log.debug((Object)"using get scheme instead of get scheme object");
        }
        return this.scheme;
    }

    public Scheme getSchemeObject() throws DataAccessException {
        if (this.schemeObject == null) {
            this.schemeObject = this.getSchemeManager().getSchemeObject(this.schemeId);
        }
        return this.schemeObject;
    }

    public void doNameValidation(String name, String mode) {
        block6: {
            if (!TextUtils.stringSet((String)name)) {
                this.addError("name", this.getText("admin.errors.specify.a.name.for.this.scheme"));
            } else {
                try {
                    Scheme existingScheme = this.getSchemeManager().getSchemeObject(name.trim());
                    if (existingScheme != null && !existingScheme.getId().equals(this.schemeId)) {
                        this.addError("name", this.getText("admin.errors.a.scheme.with.this.name.exists"));
                        break block6;
                    }
                    List schemes = this.getSchemeManager().getSchemeObjects();
                    for (Scheme scheme : schemes) {
                        if (!name.trim().equalsIgnoreCase(scheme.getName()) || scheme.getId().equals(this.schemeId)) continue;
                        this.addError("name", this.getText("admin.errors.a.scheme.with.this.name.exists"));
                        break;
                    }
                }
                catch (DataAccessException e) {
                    this.addErrorMessage(this.getText("admin.errors.error.occured.trying.to.the.scheme", mode));
                }
            }
        }
    }

    public String formatSecurityTypeParameter(String type, String parameter) {
        return SecurityTypeUtils.formatSecurityTypeParameter(type, parameter, this.getI18nHelper());
    }
}

