/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.bc.dashboard.DashboardItem;
import com.atlassian.jira.bc.dashboard.DashboardItemPropertyService;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.bc.issuetype.property.IssueTypePropertyService;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.bc.user.UserPropertyService;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeWithID;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Map;
import java.util.Optional;

@PublicApi
public class EntityPropertyEqualToCondition
extends AbstractWebCondition {
    private final Map<String, Function2<String, String, PropertyCondition>> conditionFactories = ImmutableMap.builder().put((Object)"project", (propertyKey, value) -> new ProjectPropertyCondition(projectPropertyService, (String)propertyKey, (String)value)).put((Object)"issue", (propertyKey, value) -> new IssuePropertyCondition(issuePropertyService, (String)propertyKey, (String)value)).put((Object)"comment", (propertyKey, value) -> new CommentPropertyCondition(commentPropertyService, (String)propertyKey, (String)value)).put((Object)"issuetype", (propertyKey, value) -> new IssueTypePropertyCondition(issueTypePropertyService, (String)propertyKey, (String)value)).put((Object)"user", (propertyKey, value) -> new UserPropertyCondition((EntityPropertyService<ApplicationUser>)userPropertyService, (String)propertyKey, (String)value)).put((Object)"dashboarditem", (propertyKey, value) -> new DashboardItemCondition((EntityPropertyService<DashboardItem>)dashboardItemPropertyService, (String)propertyKey, (String)value)).build();
    private PropertyCondition condition;

    public EntityPropertyEqualToCondition(CommentPropertyService commentPropertyService, IssuePropertyService issuePropertyService, IssueTypePropertyService issueTypePropertyService, ProjectPropertyService projectPropertyService, DashboardItemPropertyService dashboardItemPropertyService, UserPropertyService userPropertyService) {
    }

    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
        String entity = this.getNonNullValueFromParameter(params, "entity");
        String propertyKey = this.getNonNullValueFromParameter(params, "propertyKey");
        String expectedValue = this.getNonNullValueFromParameter(params, "value");
        if (!this.conditionFactories.containsKey(entity)) {
            throw new PluginParseException("Invalid entity parameter. Possible values are [" + this.conditionFactories.keySet() + "].");
        }
        this.condition = (PropertyCondition)this.conditionFactories.get(entity).apply((Object)propertyKey, (Object)expectedValue);
    }

    private String getNonNullValueFromParameter(Map<String, String> params, String parameter) {
        String value = params.get(parameter);
        if (value == null) {
            throw new PluginParseException(String.format("No '%s' parameter specified for condition: %s", parameter, ((Object)((Object)this)).getClass().getName()));
        }
        return value;
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return this.condition.shouldDisplay(user, jiraHelper);
    }

    private static class DashboardItemCondition
    extends PropertyCondition<DashboardItem> {
        protected DashboardItemCondition(EntityPropertyService<DashboardItem> service, String propertyKey, String value) {
            super(service, propertyKey, value);
        }

        @Override
        Optional<Long> getEntityId(Map<String, Object> context) {
            return this.get(context, "dashboardItem", Map.class).map(item -> item.get("id") != null ? Long.valueOf(item.get("id").toString()) : null);
        }
    }

    private static class UserPropertyCondition
    extends PropertyCondition<ApplicationUser> {
        protected UserPropertyCondition(EntityPropertyService<ApplicationUser> service, String propertyKey, String value) {
            super(service, propertyKey, value);
        }

        @Override
        Optional<Long> getEntityId(Map<String, Object> context) {
            return JiraWebContext.from(context).getUser().map(WithId::getId);
        }
    }

    private static class IssueTypePropertyCondition
    extends PropertyCondition<IssueTypeWithID> {
        private IssueTypePropertyCondition(IssueTypePropertyService issueTypePropertyService, String propertyKey, String value) {
            super(issueTypePropertyService, propertyKey, value);
        }

        @Override
        Optional<Long> getEntityId(Map<String, Object> context) {
            return this.get(context, "issue", Issue.class).map(issue -> IssueTypeWithID.fromIssueType((IssueType)issue.getIssueTypeObject()).getId());
        }
    }

    private static class CommentPropertyCondition
    extends PropertyConditionWithEntityInContext<Comment> {
        private CommentPropertyCondition(CommentPropertyService commentPropertyService, String propertyKey, String value) {
            super(commentPropertyService, "comment", Comment.class, propertyKey, value);
        }
    }

    private static class IssuePropertyCondition
    extends PropertyConditionWithEntityInContext<Issue> {
        private IssuePropertyCondition(IssuePropertyService issuePropertyService, String propertyKey, String value) {
            super(issuePropertyService, "issue", Issue.class, propertyKey, value);
        }
    }

    private static class ProjectPropertyCondition
    extends PropertyConditionWithEntityInContext<Project> {
        private ProjectPropertyCondition(ProjectPropertyService projectPropertyService, String propertyKey, String value) {
            super(projectPropertyService, "project", Project.class, propertyKey, value);
        }
    }

    private static abstract class PropertyConditionWithEntityInContext<T extends WithId>
    extends PropertyCondition<T> {
        private final String entityNameInContext;
        private final Class<T> entityType;

        protected PropertyConditionWithEntityInContext(EntityPropertyService<T> service, String entityNameInContext, Class<T> entityType, String propertyKey, String value) {
            super(service, propertyKey, value);
            this.entityNameInContext = entityNameInContext;
            this.entityType = entityType;
        }

        @Override
        Optional<Long> getEntityId(Map<String, Object> context) {
            return this.get(context, this.entityNameInContext, this.entityType).map(WithId::getId);
        }
    }

    private static abstract class PropertyCondition<T extends WithId> {
        private final String propertyKey;
        private final String value;
        private final EntityPropertyService service;
        private final JsonParser jsonParser = new JsonParser();

        protected PropertyCondition(EntityPropertyService<T> service, String propertyKey, String value) {
            this.service = service;
            this.propertyKey = propertyKey;
            this.value = value;
        }

        public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
            Optional<Long> entityId = this.getEntityId(jiraHelper.getContextParams());
            if (!entityId.isPresent()) {
                return false;
            }
            EntityPropertyService.PropertyResult propertyResult = this.service.getProperty(user, entityId.get(), this.propertyKey);
            if (!propertyResult.isValid()) {
                return false;
            }
            Option entityProperty = propertyResult.getEntityProperty();
            return (Boolean)entityProperty.fold(Suppliers.alwaysFalse(), (Function)new Function<EntityProperty, Boolean>(){

                public Boolean apply(EntityProperty entityProperty) {
                    JsonElement jsonElement = jsonParser.parse(entityProperty.getValue());
                    return jsonElement.isJsonPrimitive() && jsonElement.getAsString().equals(value);
                }
            });
        }

        protected final <E> Optional<E> get(Map<String, Object> context, String key, Class<E> type) {
            Object entity = context.get(key);
            return type.isInstance(entity) ? Optional.of(type.cast(entity)) : Optional.empty();
        }

        abstract Optional<Long> getEntityId(Map<String, Object> var1);
    }
}

