/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.jql.function.AbstractUserBasedFunction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ComponentsLeadByUserFunction
extends AbstractUserBasedFunction {
    public static final String FUNCTION_COMPONENTS_LEAD_BY_USER = "componentsLeadByUser";
    private static final String JIRA_JQL_COMPONENT_NO_SUCH_USER = "jira.jql.component.no.such.user";
    private final PermissionManager permissionManager;
    private final ProjectComponentManager componentManager;

    public ComponentsLeadByUserFunction(PermissionManager permissionManager, ProjectComponentManager componentManager, UserUtil userUtil) {
        super(userUtil);
        this.permissionManager = permissionManager;
        this.componentManager = (ProjectComponentManager)Assertions.notNull((String)"componentManager", (Object)componentManager);
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.COMPONENT;
    }

    @Override
    protected List<QueryLiteral> getFunctionValuesList(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, final ApplicationUser user) {
        Iterable<Object> candidateComponents = Collections.emptyList();
        if (queryCreationContext.isSecurityOverriden()) {
            Collection<ProjectComponent> components = this.getLeadComponents(user);
            candidateComponents = Iterables.concat(candidateComponents, components);
        }
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, queryCreationContext.getApplicationUser());
        for (Project project : projects) {
            candidateComponents = Iterables.concat(candidateComponents, (Iterable)Iterables.filter((Iterable)project.getProjectComponents(), (Predicate)new Predicate<ProjectComponent>(){

                public boolean apply(@Nullable ProjectComponent input) {
                    return user.getKey().equals(input.getLead());
                }
            }));
        }
        ArrayList<QueryLiteral> values = new ArrayList<QueryLiteral>();
        for (ProjectComponent projectComponent : candidateComponents) {
            values.add(new QueryLiteral((Operand)functionOperand, projectComponent.getId()));
        }
        return values;
    }

    private Collection<ProjectComponent> getLeadComponents(ApplicationUser user) {
        return this.componentManager.findComponentsByLead(user.getName());
    }

    @Override
    protected String getUserNotFoundMessageKey() {
        return JIRA_JQL_COMPONENT_NO_SUCH_USER;
    }
}

