/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mention.commands;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.issue.MentionIssueEvent;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.mail.MentionMailQueueItem;
import com.atlassian.jira.notification.JiraNotificationReason;
import com.atlassian.jira.notification.NotificationFilterManager;
import com.atlassian.jira.notification.NotificationReason;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class EmailMentionedUsers {
    private static final Logger log = LoggerFactory.getLogger(EmailMentionedUsers.class);
    private final MailQueue mailQueue;
    private final RendererManager rendererManager;
    private final MailServerManager mailServerManager;
    private final NotificationFilterManager notificationFilterManager;

    public EmailMentionedUsers(MailQueue mailQueue, RendererManager rendererManager, MailServerManager mailServerManager, NotificationFilterManager notificationFilterManager) {
        this.mailQueue = mailQueue;
        this.rendererManager = rendererManager;
        this.mailServerManager = mailServerManager;
        this.notificationFilterManager = notificationFilterManager;
    }

    @EventListener
    public void execute(MentionIssueEvent mentionIssueEvent) {
        if (this.mailServerManager.isDefaultSMTPMailServerDefined()) {
            ApplicationUser from = mentionIssueEvent.getFromUser();
            for (ApplicationUser toUser : mentionIssueEvent.getToUsers()) {
                if (toUser.getEmailAddress() == null) {
                    log.warn("User " + toUser.getName() + " does not have a registered email address. No mentioned notification will be sent.");
                    continue;
                }
                NotificationRecipient recipient = new NotificationRecipient(toUser);
                if (!this.shouldSendMention(mentionIssueEvent, recipient)) continue;
                HashMap params = Maps.newHashMap();
                params.put("comment", mentionIssueEvent.getMentionText());
                params.put("issue", mentionIssueEvent.getIssue());
                IssueRenderContext issueRenderContext = mentionIssueEvent.getIssue().getIssueRenderContext();
                MentionMailQueueItem item = new MentionMailQueueItem(from, recipient, params, issueRenderContext, this.rendererManager, this.mailQueue);
                this.mailQueue.addItem((MailQueueItem)item);
            }
        }
    }

    private boolean shouldSendMention(MentionIssueEvent mentionIssueEvent, NotificationRecipient recipient) {
        return this.userIsNotAlreadyReceivingAnEmail(mentionIssueEvent, recipient) && this.userIsNotFiltered(recipient);
    }

    private boolean userIsNotAlreadyReceivingAnEmail(MentionIssueEvent mentionIssueEvent, NotificationRecipient recipient) {
        return !mentionIssueEvent.getCurrentRecipients().contains(recipient);
    }

    private boolean userIsNotFiltered(NotificationRecipient recipient) {
        return !this.notificationFilterManager.filtered(recipient, this.notificationFilterManager.makeContextFrom((NotificationReason)JiraNotificationReason.MENTIONED));
    }
}

