/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.builder.EmailBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public class MailServiceQueueItemBuilder {
    public static final String ISSUE = "issue";
    private final NotificationRecipient recipient;
    private final Map<String, Object> context;
    private final ApplicationUser replyTo;
    private final String subjectTemplatePath;
    private final String bodyTemplatePath;

    public MailServiceQueueItemBuilder(ApplicationUser replyTo, NotificationRecipient recipient, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> context) {
        this.replyTo = replyTo;
        this.recipient = recipient;
        this.subjectTemplatePath = subjectTemplatePath;
        this.bodyTemplatePath = bodyTemplatePath;
        this.context = context;
    }

    public MailQueueItem buildQueueItem() {
        return this.createEmailBuilder(this.replyTo.getEmailAddress()).renderLater();
    }

    public MailQueueItem buildQueueItemUsingProjectEmailAsReplyTo() {
        return this.createEmailBuilder(this.getProjectEmail()).renderLater();
    }

    protected EmailBuilder createEmailBuilder(String replyToEmail) {
        EmailBuilder emailBuilder;
        Email email = new Email(this.recipient.getEmail());
        email.setFromName(JiraMailUtils.getFromNameForUser(this.replyTo));
        email.setReplyTo(replyToEmail);
        if (this.context.containsKey(ISSUE)) {
            Issue issue = (Issue)this.context.get(ISSUE);
            email.setFrom(JiraMailUtils.getProjectEmailFromIssue(issue));
            IssueEvent issueEvent = new IssueEvent(issue, (Map)Maps.newHashMap(), this.replyTo, Long.valueOf(0L));
            emailBuilder = new EmailBuilder(email, this.recipient, issueEvent);
        } else {
            email.setFrom(this.replyTo.getEmailAddress());
            emailBuilder = new EmailBuilder(email, this.recipient);
        }
        return emailBuilder.withSubjectFromFile(this.subjectTemplatePath).withBodyFromFile(this.bodyTemplatePath).addParameters(this.context);
    }

    @Nullable
    private String getProjectEmail() {
        if (!this.context.containsKey(ISSUE)) {
            return null;
        }
        Issue issue = (Issue)this.context.get(ISSUE);
        return JiraMailUtils.getProjectEmailFromIssue(issue);
    }
}

