/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.license.CreateIssueLicenseCheck;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreateIssueLicenseCheckImpl
implements CreateIssueLicenseCheck {
    private final JiraLicenseManager licenseManager;
    private final ApplicationRoleManager roleManager;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraContactHelper jiraContactHelper;
    private final I18nHelper i18n;

    public CreateIssueLicenseCheckImpl(JiraLicenseManager licenseManager, ApplicationRoleManager roleManager, JiraAuthenticationContext authenticationContext, JiraContactHelper jiraContactHelper, I18nHelper i18n) {
        this.licenseManager = licenseManager;
        this.roleManager = roleManager;
        this.authenticationContext = authenticationContext;
        this.jiraContactHelper = jiraContactHelper;
        this.i18n = i18n;
    }

    @Override
    public LicenseCheck.Result evaluate() {
        return this.evaluateWithUser(this.authenticationContext.getUser());
    }

    @Override
    public LicenseCheck.Result evaluateWithUser(ApplicationUser user) {
        if (!this.licenseManager.isLicenseSet()) {
            return new LicenseCheck.Failure(Collections.emptyList(), this.i18n.getText("createissue.error.invalid.license", this.getContactLink()));
        }
        List<LicenseDetails> expiredLicenses = this.getExpiredLicenses();
        if (!expiredLicenses.isEmpty()) {
            String i18nKey = this.instanceIsEnterprise() ? "createissue.error.enterprise.license.expired" : "createissue.error.license.expired";
            return new LicenseCheck.Failure(expiredLicenses, this.i18n.getText(i18nKey, this.getContactLink()));
        }
        if (user == null && this.roleManager.isAnyRoleLimitExceeded() || user != null && this.roleManager.hasExceededAllRoles(user)) {
            return new LicenseCheck.Failure(Collections.emptyList(), this.i18n.getText("createissue.error.license.user.limit.exceeded", this.getContactLink()));
        }
        return PASS;
    }

    private List<LicenseDetails> getExpiredLicenses() {
        ArrayList<LicenseDetails> expired = new ArrayList<LicenseDetails>();
        for (LicenseDetails license : this.licenseManager.getLicenses()) {
            if (!license.isExpired()) continue;
            expired.add(license);
        }
        return expired;
    }

    private boolean instanceIsEnterprise() {
        for (LicenseDetails license : this.licenseManager.getLicenses()) {
            if (!license.isDataCenter() && !license.isEnterpriseLicenseAgreement()) continue;
            return true;
        }
        return false;
    }

    private String getContactLink() {
        return this.jiraContactHelper.getAdministratorContactMessage(this.i18n);
    }
}

