/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.jql.query.IssueIdCollector;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryProjectRoleAndGroupPermissionsDecorator;
import com.atlassian.jira.util.InjectableComponent;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class WorklogQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(WorklogQueryExecutor.class);
    private final SearchProviderFactory searchProviderFactory;
    private final QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator;

    public WorklogQueryExecutor(SearchProviderFactory searchProviderFactory, QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator) {
        this.searchProviderFactory = searchProviderFactory;
        this.queryPermissionsDecorator = queryPermissionsDecorator;
    }

    public Iterable<Long> executeWorklogQuery(Query worklogQuery, QueryCreationContext context) {
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("worklog");
        IssueIdCollector collector = new IssueIdCollector(searcher.getIndexReader());
        try {
            Query permissionChecksDecoratedQuery = this.queryPermissionsDecorator.decorateWorklogQueryWithPermissionChecks(worklogQuery, context);
            searcher.search(permissionChecksDecoratedQuery, (Collector)collector);
            return Iterables.transform(collector.getIssueIds(), (Function)new Function<String, Long>(){

                public Long apply(@Nullable String input) {
                    return Long.valueOf(input);
                }
            });
        }
        catch (IOException e) {
            log.error("Unable to search the worklog index.", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

