/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.vote.VoteHistoryEntry;
import com.atlassian.jira.issue.vote.VoteHistoryEntryImpl;
import com.atlassian.jira.issue.vote.VoteHistoryStore;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVoteManager
implements VoteManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultVoteManager.class);
    private static final String ASSOCIATION_TYPE = "VoteIssue";
    private static final String CACHE_KEY = DefaultVoteManager.class.getName() + ".voters";
    private final ApplicationProperties applicationProperties;
    private final UserAssociationStore userAssociationStore;
    private final VoteHistoryStore voteHistoryStore;
    private final IssueIndexManager indexManager;
    private final IssueManager issueManager;
    private final IssueFactory issueFactory;
    private final UserManager userManager;

    public DefaultVoteManager(ApplicationProperties applicationProperties, UserAssociationStore userAssociationStore, IssueIndexManager indexManager, VoteHistoryStore voteHistoryStore, IssueManager issueManager, IssueFactory issueFactory, UserManager userManager) {
        this.applicationProperties = applicationProperties;
        this.userAssociationStore = userAssociationStore;
        this.indexManager = indexManager;
        this.voteHistoryStore = voteHistoryStore;
        this.issueManager = issueManager;
        this.issueFactory = issueFactory;
        this.userManager = userManager;
    }

    public boolean addVote(ApplicationUser user, Issue issue) {
        return this.updateVote(true, user, issue.getGenericValue());
    }

    public boolean addVote(ApplicationUser user, GenericValue issue) {
        return this.updateVote(true, user, issue);
    }

    public boolean removeVote(ApplicationUser user, GenericValue issue) {
        return this.updateVote(false, user, issue);
    }

    public boolean removeVote(ApplicationUser user, Issue issue) {
        return this.updateVote(false, user, issue.getGenericValue());
    }

    public Collection<String> getVoterUsernames(Issue issue) {
        Collection<String> voterKeys = this.getVoterUserkeys(issue);
        return (Collection)voterKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKeyEvenWhenUnknown(arg_0)).filter(user -> user != null).map(ApplicationUser::getUsername).collect(CollectorsUtil.toNewArrayListWithSizeOf(voterKeys));
    }

    public Collection<String> getVoterUsernames(GenericValue issue) {
        return this.getVoterUsernames((Issue)this.issueFactory.getIssue(issue));
    }

    public Collection<String> getVoterUserkeys(Issue issue) {
        return (Collection)this.getVotersCache().getUnchecked((Object)issue.getId());
    }

    public int getVoteCount(Issue issue) {
        return this.getVoterUsernames(issue).size();
    }

    public List<VoteHistoryEntry> getVoteHistory(Issue issue) {
        return this.voteHistoryStore.getHistory(issue.getId());
    }

    public List<ApplicationUser> getVoters(Issue issue, Locale usersLocale) {
        return this.getVotersFor(issue, usersLocale);
    }

    public List<ApplicationUser> getVotersFor(Issue issue, Locale usersLocale) {
        Collection<String> voterKeys = this.getVoterUserkeys(issue);
        return (List)voterKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKeyEvenWhenUnknown(arg_0)).filter(user -> user != null).sorted((Comparator<ApplicationUser>)new ApplicationUserBestNameComparator(usersLocale)).collect(CollectorsUtil.toNewArrayListWithSizeOf(voterKeys));
    }

    private boolean updateVote(boolean isVoting, ApplicationUser user, GenericValue issue) {
        if (this.validateUpdate(user, issue)) {
            try {
                if (isVoting) {
                    if (!this.hasVoted(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        this.getVotersCache().invalidate((Object)issue.getLong("id"));
                        this.adjustVoteCount(issue, 1);
                        return true;
                    }
                } else if (this.hasVoted(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user.getKey(), "Issue", issue.getLong("id"));
                    this.getVotersCache().invalidate((Object)issue.getLong("id"));
                    this.adjustVoteCount(issue, -1);
                    return true;
                }
            }
            catch (GenericEntityException e) {
                log.error("Error changing vote association", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void adjustVoteCount(GenericValue originalIssue, int adjustValue) throws GenericEntityException {
        long votes = this.recalculateVoters(originalIssue, adjustValue);
        Long issueId = originalIssue.getLong("id");
        GenericValue clonedIssue = (GenericValue)originalIssue.clone();
        clonedIssue.clear();
        clonedIssue.set("id", (Object)originalIssue.getLong("id"));
        clonedIssue.set("votes", (Object)votes);
        clonedIssue.store();
        originalIssue.set("votes", (Object)votes);
        Timestamp now = new Timestamp(new Date().getTime());
        this.voteHistoryStore.add(new VoteHistoryEntryImpl(originalIssue.getLong("id"), now, votes));
        try {
            MutableIssue updatedIssue = this.issueManager.getIssueObject(issueId);
            this.indexManager.reIndex((Issue)updatedIssue, IssueIndexingParams.INDEX_ISSUE_ONLY);
        }
        catch (IndexException e) {
            log.error("Exception re-indexing issue " + (Object)((Object)e), (Throwable)e);
        }
    }

    private Long recalculateVoters(GenericValue issue, int adjustValue) {
        Long votes = issue.getLong("votes");
        if (votes == null) {
            votes = 0L;
        }
        if ((votes = Long.valueOf(votes + (long)adjustValue)) < 0L) {
            votes = 0L;
        }
        return votes;
    }

    private boolean validateUpdate(ApplicationUser user, GenericValue issue) {
        if (issue == null) {
            log.error("You must specify an issue.");
            return false;
        }
        if (!this.isVotingEnabled()) {
            log.error("Voting is not enabled - the change vote on issue " + issue.getString("key") + " by user " + user.getUsername() + " was unsuccessful.");
            return false;
        }
        if (issue.getString("resolution") != null) {
            log.error("Cannot change vote on issue that has been resolved.");
            return false;
        }
        if (user == null) {
            log.error("You must specify a user.");
            return false;
        }
        return true;
    }

    public boolean isVotingEnabled() {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    public boolean hasVoted(ApplicationUser user, Issue issue) {
        if (user == null) {
            return false;
        }
        return issue.getVotes() != 0L && ((ImmutableSet)this.getVotersCache().getUnchecked((Object)issue.getId())).contains((Object)user.getKey());
    }

    public boolean hasVoted(ApplicationUser user, GenericValue issue) {
        if (user == null) {
            return false;
        }
        return issue.getLong("votes") != 0L && ((ImmutableSet)this.getVotersCache().getUnchecked((Object)issue.getLong("id"))).contains((Object)user.getKey());
    }

    public void removeVotesForUser(ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        List<GenericValue> issueGvs = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        for (GenericValue issueGv : issueGvs) {
            this.updateVote(false, user, issueGv);
        }
    }

    @Nonnull
    protected LoadingCache<Long, ImmutableSet<String>> getVotersCache() {
        return (LoadingCache)JiraAuthenticationContextImpl.getRequestCache(CACHE_KEY, () -> CacheBuilder.newBuilder().build(CacheLoader.from(issueId -> ImmutableSet.copyOf(this.userAssociationStore.getUserkeysFromIssue(ASSOCIATION_TYPE, (Long)issueId)))));
    }
}

