/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.WebRequestUtils;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentIdSequencer;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.ConvertTemporaryAttachmentParams;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.EitherUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ServletActionContext;

public class DefaultAttachmentManager
implements AttachmentManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentManager.class);
    private static final int NOT_THUMBNAILABLE = 0;
    private static final int IS_THUMBNAILABLE = 1;
    private static final int NOT_ZIP = 0;
    private static final int IS_ZIP = 1;
    private static final com.google.common.base.Function<AttachmentError, String> GET_ATTACHMENT_ERROR_MESSAGE = new com.google.common.base.Function<AttachmentError, String>(){

        public String apply(AttachmentError e) {
            return String.format("%s: %s.", e.getFilename(), e.getLogMessage());
        }
    };
    private static final com.google.common.base.Function<Attachment, ChangeItemBean> ATTACHMENT_TO_CHANGE_ITEM_BEAN = new com.google.common.base.Function<Attachment, ChangeItemBean>(){

        public ChangeItemBean apply(Attachment attachment) {
            return new ChangeItemBean("jira", "Attachment", null, null, attachment.getId().toString(), attachment.getFilename());
        }
    };
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final MimeManager mimeManager;
    private final ApplicationProperties applicationProperties;
    private final AttachmentPathManager attachmentPathManager;
    private final ComponentLocator componentLocator;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final UserManager userManager;
    private final AttachmentStore attachmentStore;
    private final AttachmentIndexManager attachmentIndexManager;
    private final StreamAttachmentStore streamAttachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;
    private final AttachmentIdSequencer attachmentIdSequencer;

    public DefaultAttachmentManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, MimeManager mimeManager, ApplicationProperties applicationProperties, AttachmentPathManager attachmentPathManager, ComponentLocator componentLocator, I18nHelper.BeanFactory i18nBeanFactory, UserManager userManager, AttachmentStore attachmentStore, AttachmentIndexManager attachmentIndexManager, StreamAttachmentStore streamAttachmentStore, ThumbnailAccessor thumbnailAccessor, AttachmentIdSequencer attachmentIdSequencer) {
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
        this.mimeManager = mimeManager;
        this.applicationProperties = applicationProperties;
        this.attachmentPathManager = attachmentPathManager;
        this.componentLocator = componentLocator;
        this.i18nBeanFactory = i18nBeanFactory;
        this.userManager = userManager;
        this.attachmentStore = attachmentStore;
        this.attachmentIndexManager = attachmentIndexManager;
        this.streamAttachmentStore = streamAttachmentStore;
        this.thumbnailAccessor = thumbnailAccessor;
        this.attachmentIdSequencer = attachmentIdSequencer;
    }

    public Attachment getAttachment(Long id) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", id);
        }
        catch (DataAccessException e) {
            log.error("Unable to find a file attachment with id: " + id);
            throw e;
        }
        if (attachmentGV == null) {
            throw new AttachmentNotFoundException((Object)id);
        }
        return new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV));
    }

    public List<Attachment> getAttachments(Issue issue) {
        return this.getStoredAttachments(issue);
    }

    public List<Attachment> getStoredAttachments(Issue issue) {
        try {
            GenericValue issueGV = issue.getGenericValue();
            List attachmentGvs = issueGV.getRelatedOrderBy("ChildFileAttachment", (List)ImmutableList.of((Object)"filename ASC", (Object)"created DESC"));
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(attachmentGvs.size());
            for (GenericValue attachmentGV : attachmentGvs) {
                attachments.add(new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV)));
            }
            return attachments;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<Attachment> getStoredAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        List<Attachment> attachments = this.getStoredAttachments(issue);
        Collections.sort(attachments, comparator);
        return attachments;
    }

    public List<Attachment> getAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        return this.getStoredAttachments(issue, comparator);
    }

    public Attachment createAttachmentCopySourceFile(File file, String filename, String contentType, String attachmentAuthor, Issue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return this.raiseExceptionOnError(this.createAttachmentImpl(new CreateAttachmentParamsBean.Builder(file, filename, contentType, this.userManager.getUserByName(attachmentAuthor), issue).attachmentProperties(attachmentProperties).createdTime(createdTime).copySourceFile(Boolean.valueOf(true)).build()));
    }

    public Attachment createAttachment(GenericValue issue, @Nullable ApplicationUser author, String mimetype, String filename, Long filesize, Map<String, Object> attachmentProperties, Date createdTime) {
        Long attachmentId = this.attachmentIdSequencer.getNextId();
        return this.insertAttachment(issue.getLong("id"), ApplicationUsers.getKeyFor(author), mimetype, filename, filesize, null, null, attachmentProperties, createdTime, attachmentId);
    }

    private Attachment insertAttachment(Long issueId, @Nullable String authorKey, String mimetype, String filename, Long filesize, @Nullable Boolean zip, @Nullable Boolean thumbnailable, @Nullable Map<String, Object> attachmentProperties, Date createdTime, Long attachmentId) {
        String sanitisedMimeType = this.mimeManager.getSanitisedMimeType(mimetype, filename);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issueId);
        fields.put("author", authorKey);
        fields.put("mimetype", sanitisedMimeType);
        fields.put("filename", filename);
        fields.put("filesize", filesize);
        fields.put("id", attachmentId);
        if (zip != null) {
            fields.put("zip", zip != false ? 1 : 0);
        }
        if (thumbnailable != null) {
            fields.put("thumbnailable", thumbnailable != false ? 1 : 0);
        }
        Timestamp createdTimeAsTimestamp = createdTime != null ? new Timestamp(createdTime.getTime()) : null;
        fields.put("created", createdTimeAsTimestamp);
        GenericValue attachmentGV = this.ofBizDelegator.createValue("FileAttachment", fields);
        if (attachmentProperties != null) {
            PropertySet propSet = this.createAttachmentPropertySet(attachmentGV, attachmentProperties);
            return new Attachment(this.issueManager, attachmentGV, propSet);
        }
        return new Attachment(this.issueManager, attachmentGV);
    }

    public void deleteAttachment(Attachment attachment) throws RemoveException {
        Issue issue = attachment.getIssue();
        try {
            this.attachmentStore.deleteAttachment(attachment).claim();
            this.ofBizDelegator.removeAll(CollectionBuilder.list((Object[])new GenericValue[]{attachment.getGenericValue()}));
            this.attachmentIndexManager.removeAttachmentIndex(attachment, issue);
        }
        catch (AttachmentCleanupException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    public void deleteAttachmentDirectory(Issue issue) throws RemoveException {
        if (issue != null && this.attachmentsAllowedAndDirectoryIsSet()) {
            File[] attachmentDirFiles;
            File attachmentDir = this.attachmentStore.getAttachmentDirectory(issue);
            if (!attachmentDir.isDirectory()) {
                throw new RemoveException("Attachment path '" + attachmentDir + "' is not a directory");
            }
            if (!attachmentDir.canWrite()) {
                throw new RemoveException("Can't write to attachment directory '" + attachmentDir + "'");
            }
            File thumbnailDirectory = new File(attachmentDir, "thumbs");
            if (thumbnailDirectory.exists()) {
                File[] thumbnails = thumbnailDirectory.listFiles();
                if (thumbnails == null) {
                    log.error("Unable to delete the issue attachment thumbnail directory '" + thumbnailDirectory + "' due to error while getting files list.");
                } else if (thumbnails.length == 0) {
                    boolean deleted = thumbnailDirectory.delete();
                    if (!deleted) {
                        log.error("Unable to delete the issue attachment thumbnail directory '" + thumbnailDirectory + "'.");
                    }
                } else {
                    log.error("Unable to delete the issue attachment thumbnail directory '" + thumbnailDirectory + "' because it is not empty.");
                }
            }
            if ((attachmentDirFiles = attachmentDir.listFiles()) == null) {
                log.error("Unable to delete the issue attachment directory '" + attachmentDir + "' due to error while getting files list.");
            } else if (attachmentDirFiles.length == 0) {
                if (!attachmentDir.delete()) {
                    log.error("Unable to delete the issue attachment directory '" + attachmentDir + "'.");
                }
            } else {
                log.error("Unable to delete the issue attachment directory '" + attachmentDir + "' because it is not empty.");
            }
        }
    }

    IssueFactory getIssueFactory() {
        return (IssueFactory)this.componentLocator.getComponent(IssueFactory.class);
    }

    private boolean attachmentsAllowedAndDirectoryIsSet() {
        String attachmentDir = this.attachmentPathManager.getAttachmentPath();
        return this.applicationProperties.getOption("jira.option.allowattachments") && StringUtils.isNotBlank((String)attachmentDir);
    }

    public boolean attachmentsEnabled() {
        boolean allowAttachments = this.applicationProperties.getOption("jira.option.allowattachments");
        boolean attachmentPathSet = StringUtils.isNotBlank((String)this.attachmentPathManager.getAttachmentPath());
        return allowAttachments && attachmentPathSet;
    }

    public boolean isScreenshotAppletEnabled() {
        return this.applicationProperties.getOption("jira.screenshotapplet.enabled");
    }

    protected boolean isScreenshotAppletEnabledForLinux() {
        return this.applicationProperties.getOption("jira.screenshotapplet.linux.enabled");
    }

    public boolean isScreenshotAppletSupportedByOS() {
        if (this.isScreenshotAppletEnabledForLinux()) {
            return true;
        }
        int browserOS = this.getUsersOS();
        return browserOS == 10 || browserOS == 20;
    }

    public AttachmentsBulkOperationResult<ChangeItemBean> tryConvertTemporaryAttachments(final @Nullable ApplicationUser user, final Issue issue, List<Long> selectedAttachments, final TemporaryAttachmentsMonitor temporaryAttachmentsMonitor) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"selectedAttachments", selectedAttachments);
        Assertions.notNull((String)"temporaryAttachmentsMonitor", (Object)temporaryAttachmentsMonitor);
        return new AttachmentsBulkOperationResult(EitherUtils.splitEithers(ImmutableList.copyOf((Iterable)Iterables.transform(selectedAttachments, (com.google.common.base.Function)new com.google.common.base.Function<Long, Either<AttachmentError, ChangeItemBean>>(){

            public Either<AttachmentError, ChangeItemBean> apply(Long selectedAttachment) {
                return DefaultAttachmentManager.this.transformTemporaryAttachment(selectedAttachment, temporaryAttachmentsMonitor, user, issue);
            }
        }))));
    }

    private Either<AttachmentError, ChangeItemBean> transformTemporaryAttachment(Long selectedAttachment, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor, @Nullable ApplicationUser user, Issue issue) {
        TemporaryAttachment tempAttachment = temporaryAttachmentsMonitor.getById(selectedAttachment);
        if (tempAttachment == null) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.temp.file.not.exists");
            return this.attachmentError("Temporary attachment missing: " + selectedAttachment, errorMessage, "#" + selectedAttachment, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(tempAttachment.getFile(), tempAttachment.getFilename(), tempAttachment.getContentType(), user, issue).build());
    }

    int getUsersOS() {
        HttpServletRequest servletRequest = ExecutingHttpRequest.get();
        if (servletRequest == null) {
            servletRequest = ServletActionContext.getRequest();
        }
        return WebRequestUtils.getBrowserOperationSystem(servletRequest);
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return this.raiseExceptionOnError(this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(file, filename, contentType, remoteUser, issue).attachmentProperties(attachmentProperties).createdTime(createdTime).build()));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        if (!this.validateOldCreateAttachmentArguments(file, filename)) {
            return null;
        }
        return this.raiseExceptionOnError(this.tryCreateAttachment(new CreateAttachmentParamsBean.Builder(file, filename, contentType, remoteUser, issue).zip(zip).thumbnailable(thumbnailable).attachmentProperties(attachmentProperties).createdTime(createdTime).build()));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser author, GenericValue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, author, issue, null, null, attachmentProperties, createdTime);
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser author, GenericValue issue, Boolean zip, Boolean thumbnailable, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, author, (Issue)this.getIssueFactory().getIssue(issue), zip, thumbnailable, attachmentProperties, createdTime);
    }

    private <T> T raiseExceptionOnError(Either<AttachmentError, T> result) throws AttachmentException {
        return (T)Eithers.getOrThrow((Either)result.left().map((com.google.common.base.Function)new com.google.common.base.Function<AttachmentError, AttachmentException>(){

            public AttachmentException apply(AttachmentError attachmentError) {
                return new AttachmentException(String.format("Got error while saving attachment %s: %s", attachmentError.getFilename(), attachmentError.getLogMessage()), (Throwable)attachmentError.getException().getOrNull());
            }
        }));
    }

    private Either<AttachmentError, Attachment> createAttachmentImpl(CreateAttachmentParamsBean params) {
        return this.createAttachmentFromFile(params.getFile(), params.getFilename(), params.getContentType(), params.getAuthor(), params.getIssue(), params.getZip(), params.getThumbnailable(), params.getAttachmentProperties(), params.getCreatedTime(), params.getCopySourceFile());
    }

    private boolean validateOldCreateAttachmentArguments(File file, String filename) {
        if (file == null) {
            log.warn("Cannot create attachment without a file (filename=" + filename + ").");
            return false;
        }
        if (filename == null) {
            log.warn(String.format("Cannot create attachment without a filename - inline content? See http://jira.atlassian.com/browse/JRA-10825 (file=%s).", file.getName()));
            return false;
        }
        return true;
    }

    private Either<AttachmentError, Attachment> createAttachmentFromFile(File file, final String filename, final String contentType, final @Nullable ApplicationUser author, final Issue issue, final Boolean zip, final Boolean thumbnailable, final Map<String, Object> attachmentProperties, final Date createdTime, Boolean copySourceFile) {
        final AttachmentKey attachmentKey = this.createAttachmentKey(filename, issue);
        final long fileSize = file.length();
        Either<AttachmentError, StoreAttachmentResult> putResult = this.safelyPutAttachmentFileToAttachmentStore(attachmentKey, file, !Boolean.TRUE.equals(copySourceFile), author);
        return putResult.right().map((com.google.common.base.Function)new com.google.common.base.Function<StoreAttachmentResult, Attachment>(){

            public Attachment apply(StoreAttachmentResult ignore) {
                return DefaultAttachmentManager.this.insertAttachment(issue.getId(), ApplicationUsers.getKeyFor(author), contentType, filename, fileSize, zip, thumbnailable, attachmentProperties, createdTime, attachmentKey.getAttachmentId());
            }
        });
    }

    private Either<AttachmentError, Attachment> createAttachmentFromTemporaryAttachment(final ConvertTemporaryAttachmentParams params) {
        final String filename = params.getFilename();
        final Issue issue = params.getIssue();
        final ApplicationUser author = params.getAuthor();
        final long fileSize = params.getFileSize();
        final Timestamp createdTime = new Timestamp(params.getCreatedTime().getMillis());
        final AttachmentKey attachmentKey = this.createAttachmentKey(filename, issue);
        Either<AttachmentError, Unit> moveResult = this.safelyMoveTemporaryToAttachment(attachmentKey, params.getTemporaryAttachmentId(), author);
        return moveResult.right().map((com.google.common.base.Function)new com.google.common.base.Function<Object, Attachment>(){

            public Attachment apply(Object ignore) {
                Boolean zip = null;
                Boolean thumbnailable = null;
                Map attachmentProperties = null;
                return DefaultAttachmentManager.this.insertAttachment(issue.getId(), ApplicationUsers.getKeyFor(author), params.getContentType(), filename, fileSize, zip, thumbnailable, attachmentProperties, createdTime, attachmentKey.getAttachmentId());
            }
        });
    }

    private AttachmentKey createAttachmentKey(String filename, Issue issue) {
        Long attachmentId = this.attachmentIdSequencer.getNextId();
        return AttachmentKey.builder().withAttachmentFilename(filename).withIssueKey(issue.getKey()).withAttachmentId(attachmentId).withProjectKey(issue.getProjectObject().getOriginalKey()).build();
    }

    private I18nHelper getI18n(@Nullable ApplicationUser user) {
        return this.i18nBeanFactory.getInstance(user);
    }

    private <T> Either<AttachmentError, T> attachmentError(String logMessage, String localizedMessage, String filename, ErrorCollection.Reason reason) {
        log.warn(logMessage);
        return Either.left((Object)new AttachmentError(logMessage, localizedMessage, filename, Option.none(), reason));
    }

    private <T> Either<AttachmentError, T> attachmentError(String logMessage, String localizedMessage, String filename, Throwable throwable, ErrorCollection.Reason reason) {
        String messageWithException = ExceptionUtil.logExceptionWithWarn(log, logMessage, throwable);
        Option ex = throwable instanceof Exception ? Option.some((Object)((Exception)throwable)) : Option.none();
        return Either.left((Object)new AttachmentError(messageWithException, localizedMessage, filename, ex, reason));
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, GenericValue issue) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, remoteUser, issue, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, @Nullable ApplicationUser remoteUser, Issue issue) throws AttachmentException {
        return this.createAttachment(file, filename, contentType, remoteUser, issue, Collections.emptyMap(), (Date)UtilDateTime.nowTimestamp());
    }

    public ChangeItemBean createAttachment(CreateAttachmentParamsBean bean) throws AttachmentException {
        return this.raiseExceptionOnError(this.tryCreateAttachment(bean));
    }

    public Either<AttachmentError, ChangeItemBean> tryCreateAttachment(CreateAttachmentParamsBean params) {
        return this.createAttachmentImpl(params).right().map(ATTACHMENT_TO_CHANGE_ITEM_BEAN);
    }

    public List<ChangeItemBean> convertTemporaryAttachments(@Nullable ApplicationUser user, Issue issue, List<Long> selectedAttachments, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor) throws AttachmentException {
        AttachmentsBulkOperationResult<ChangeItemBean> convertResult = this.tryConvertTemporaryAttachments(user, issue, selectedAttachments, temporaryAttachmentsMonitor);
        if (!convertResult.getErrors().isEmpty()) {
            String errors = Joiner.on((String)" ").join(Iterables.transform((Iterable)convertResult.getErrors(), GET_ATTACHMENT_ERROR_MESSAGE));
            throw new AttachmentException("Got errors when attaching files. " + errors);
        }
        return convertResult.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    StoreAttachmentResult putAttachmentFileToAttachmentStore(AttachmentKey attachmentKey, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream is = new BufferedInputStream(fis);
        StoreAttachmentBean storeAttachmentBean = new StoreAttachmentBean.Builder((InputStream)is).withSize(file.length()).withKey(attachmentKey).build();
        try {
            StoreAttachmentResult storeAttachmentResult = (StoreAttachmentResult)this.streamAttachmentStore.putAttachment(storeAttachmentBean).claim();
            return storeAttachmentResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Either<AttachmentError, StoreAttachmentResult> safelyPutAttachmentFileToAttachmentStore(AttachmentKey attachmentKey, File file, boolean deleteSourceFile, @Nullable ApplicationUser user) {
        try {
            Either either = Either.right((Object)this.putAttachmentFileToAttachmentStore(attachmentKey, file));
            return either;
        }
        catch (Exception e) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.save.to.store", (Object)e);
            Either either = this.attachmentError("Got exception while saving attachment in attachment store.", errorMessage, attachmentKey.getAttachmentFilename(), e, ErrorCollection.Reason.SERVER_ERROR);
            return either;
        }
        finally {
            if (deleteSourceFile && !file.delete()) {
                log.warn("Cannot remove source attachment file " + file);
            }
        }
    }

    @VisibleForTesting
    Either<AttachmentError, Unit> safelyMoveTemporaryToAttachment(AttachmentKey attachmentKey, TemporaryAttachmentId temporaryAttachmentId, @Nullable ApplicationUser user) {
        try {
            return Either.right((Object)this.streamAttachmentStore.moveTemporaryToAttachment(temporaryAttachmentId, attachmentKey).claim());
        }
        catch (Exception e) {
            String errorMessage = this.getI18n(user).getText("attachfile.error.save.to.store", e.getMessage());
            return this.attachmentError("Got exception while saving attachment in attachment store.", errorMessage, attachmentKey.getAttachmentFilename(), e, ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    PropertySet createAttachmentPropertySet(GenericValue attachment, Map<String, Object> attachmentProperties) {
        PropertySet propSet = OFBizPropertyUtils.getPropertySet(attachment);
        for (Map.Entry<String, Object> entry : attachmentProperties.entrySet()) {
            propSet.setAsActualType(entry.getKey(), entry.getValue());
        }
        return propSet;
    }

    public Attachment setThumbnailable(Attachment attachment, boolean thumbnailable) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", attachment.getId());
            attachmentGV.put("thumbnailable", (Object)(thumbnailable ? 1 : 0));
            attachmentGV.store();
        }
        catch (DataAccessException e) {
            log.error("Unable to find a file attachment with id: " + attachment.getId());
            throw e;
        }
        catch (GenericEntityException e) {
            log.error("Unable to find a file attachment with id: " + attachment.getId());
            throw new DataAccessException((Throwable)e);
        }
        return new Attachment(this.issueManager, attachmentGV, attachment.getProperties());
    }

    public Attachment setZip(Attachment attachment, boolean zip) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findById("FileAttachment", attachment.getId());
            attachmentGV.put("zip", (Object)(zip ? 1 : 0));
            attachmentGV.store();
        }
        catch (DataAccessException e) {
            log.error("Unable to find a file attachment with id: " + attachment.getId());
            throw e;
        }
        catch (GenericEntityException e) {
            log.error("Unable to find a file attachment with id: " + attachment.getId());
            throw new DataAccessException((Throwable)e);
        }
        return new Attachment(this.issueManager, attachmentGV, attachment.getProperties());
    }

    public <T> T streamAttachmentContent(@Nonnull Attachment attachment, final InputStreamConsumer<T> consumer) throws AttachmentReadException, NoAttachmentDataException {
        return (T)this.attachmentStore.getAttachment(attachment, new Function<InputStream, T>(){

            public T get(InputStream input) {
                try {
                    return consumer.withInputStream(input);
                }
                catch (IOException e) {
                    throw new DataAccessException((Throwable)e);
                }
            }
        }).claim();
    }

    public void moveAttachments(final Issue oldIssue, final String newIssueKey) {
        List<Attachment> attachments = this.getAttachments(oldIssue);
        com.google.common.base.Function<Throwable, Void> logFailure = new com.google.common.base.Function<Throwable, Void>(){

            public Void apply(Throwable t) {
                log.warn(t.getMessage());
                return null;
            }
        };
        com.google.common.base.Function<Attachment, Promise<Void>> move = new com.google.common.base.Function<Attachment, Promise<Void>>((com.google.common.base.Function)logFailure){
            final /* synthetic */ com.google.common.base.Function val$logFailure;
            {
                this.val$logFailure = function;
            }

            public Promise<Void> apply(Attachment attachment) {
                if (!DefaultAttachmentManager.this.deleteThumbnailForAttachment(oldIssue, attachment)) {
                    log.info(String.format("Unable to delete thumbnail for attachment %s", attachment.getId().toString()));
                }
                return DefaultAttachmentManager.this.attachmentStore.move(attachment, newIssueKey).recover(this.val$logFailure);
            }
        };
        Promises.when((Iterable)ImmutableList.copyOf((Iterable)Iterables.transform(attachments, (com.google.common.base.Function)move))).claim();
        this.deleteThumbnailsDirectoryForIssue(oldIssue);
    }

    private void deleteThumbnailsDirectoryForIssue(Issue issue) {
        File thumbnailDirectory = this.thumbnailAccessor.getThumbnailDirectory(issue, false);
        if (thumbnailDirectory.exists() && !thumbnailDirectory.delete()) {
            log.info(String.format("Unable to delete thumbnail directory of issue %s", issue.getKey()));
        }
    }

    private boolean deleteThumbnailForAttachment(Issue issue, Attachment attachment) {
        File thumbnailFile = issue == null ? this.thumbnailAccessor.getThumbnailFile(attachment) : this.thumbnailAccessor.getThumbnailFile(issue, attachment);
        return !thumbnailFile.exists() || thumbnailFile.delete();
    }

    public Either<AttachmentError, Attachment> copyAttachment(Attachment attachment, @Nullable ApplicationUser author, String newIssueKey) {
        return this.copyAttachments(Collections.singletonList(attachment), author, newIssueKey).get(attachment.getId());
    }

    public Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Issue issue, @Nullable ApplicationUser author, String newIssueKey) {
        return this.copyAttachments(this.getAttachments(issue), author, newIssueKey);
    }

    private <A> Map<Long, A> fillMap(List<Attachment> attachments, com.google.common.base.Function<Attachment, A> f) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attachment attachment : attachments) {
            builder.put((Object)attachment.getId(), f.apply((Object)attachment));
        }
        return builder.build();
    }

    private Map<Long, Either<AttachmentError, Attachment>> copyAttachments(List<Attachment> attachments, final @Nullable ApplicationUser author, final String newIssueKey) {
        MutableIssue newIssue;
        try {
            newIssue = this.issueManager.getIssueObject(newIssueKey);
            if (newIssue == null) {
                return this.fillMap(attachments, new com.google.common.base.Function<Attachment, Either<AttachmentError, Attachment>>(){

                    public Either<AttachmentError, Attachment> apply(Attachment attachment) {
                        return DefaultAttachmentManager.this.attachmentError(String.format("Unable to copy attachment because issue with key %s does not exist", newIssueKey), DefaultAttachmentManager.this.getI18n(author).getText("attachment.error.copy.issue.not.exist", newIssueKey), attachment.getFilename(), ErrorCollection.Reason.VALIDATION_FAILED);
                    }
                });
            }
        }
        catch (DataAccessException exception) {
            return this.fillMap(attachments, new com.google.common.base.Function<Attachment, Either<AttachmentError, Attachment>>(){

                public Either<AttachmentError, Attachment> apply(Attachment attachment) {
                    return DefaultAttachmentManager.this.copyAttachmentError(attachment, author, newIssueKey, exception);
                }
            });
        }
        String authorKey = ApplicationUsers.getKeyFor(author);
        com.google.common.base.Function<Attachment, Promise<Pair<Long, Either<AttachmentError, Attachment>>>> copy = new com.google.common.base.Function<Attachment, Promise<Pair<Long, Either<AttachmentError, Attachment>>>>((Issue)newIssue, authorKey, author, newIssueKey){
            final /* synthetic */ Issue val$newIssue;
            final /* synthetic */ String val$authorKey;
            final /* synthetic */ ApplicationUser val$author;
            final /* synthetic */ String val$newIssueKey;
            {
                this.val$newIssue = issue;
                this.val$authorKey = string;
                this.val$author = applicationUser;
                this.val$newIssueKey = string2;
            }

            public Promise<Pair<Long, Either<AttachmentError, Attachment>>> apply(final Attachment attachment) {
                Attachment newAttachmentMetaData;
                Long attachmentId = DefaultAttachmentManager.this.attachmentIdSequencer.getNextId();
                try {
                    newAttachmentMetaData = DefaultAttachmentManager.this.insertAttachment(this.val$newIssue.getId(), this.val$authorKey, attachment.getMimetype(), attachment.getFilename(), attachment.getFilesize(), attachment.isZip(), attachment.isThumbnailable(), null, UtilDateTime.nowTimestamp(), attachmentId);
                }
                catch (DataAccessException exception) {
                    return Promises.rejected((Throwable)exception);
                }
                com.google.common.base.Function<Attachment, Pair<Long, Either<AttachmentError, Attachment>>> handleResult = new com.google.common.base.Function<Attachment, Pair<Long, Either<AttachmentError, Attachment>>>(){

                    public Pair<Long, Either<AttachmentError, Attachment>> apply(Attachment newAttachment) {
                        return Pair.pair((Object)attachment.getId(), (Object)Either.right((Object)newAttachment));
                    }
                };
                com.google.common.base.Function<Throwable, Pair<Long, Either<AttachmentError, Attachment>>> rollbackAndReturnError = new com.google.common.base.Function<Throwable, Pair<Long, Either<AttachmentError, Attachment>>>(){

                    public Pair<Long, Either<AttachmentError, Attachment>> apply(Throwable t) {
                        AttachmentError error = (AttachmentError)DefaultAttachmentManager.this.copyAttachmentError(attachment, val$author, val$newIssueKey, t).left().get();
                        try {
                            DefaultAttachmentManager.this.ofBizDelegator.removeValue(newAttachmentMetaData.getGenericValue());
                        }
                        catch (DataAccessException exception) {
                            AttachmentError dbError = (AttachmentError)DefaultAttachmentManager.this.copyAttachmentError(attachment, val$author, val$newIssueKey, exception).left().get();
                            log.warn(dbError.getLogMessage(), (Throwable)dbError.getException().getOrNull());
                        }
                        return Pair.pair((Object)attachment.getId(), (Object)Either.left((Object)error));
                    }
                };
                return DefaultAttachmentManager.this.attachmentStore.copy(attachment, newAttachmentMetaData, this.val$newIssueKey).map((com.google.common.base.Function)handleResult).recover((com.google.common.base.Function)rollbackAndReturnError);
            }
        };
        List results = (List)Promises.when((Iterable)ImmutableList.copyOf((Iterable)Iterables.transform(attachments, (com.google.common.base.Function)copy))).claim();
        HashMap<Long, Either<AttachmentError, Attachment>> map = new HashMap<Long, Either<AttachmentError, Attachment>>(attachments.size());
        for (Pair result : results) {
            map.put((Long)result.left(), (Either<AttachmentError, Attachment>)result.right());
        }
        return map;
    }

    public TemporaryAttachmentId createTemporaryAttachment(InputStream stream, long size) {
        return (TemporaryAttachmentId)this.streamAttachmentStore.putTemporaryAttachment(stream, size).claim();
    }

    public void deleteTemporaryAttachment(final TemporaryAttachmentId temporaryAttachmentId) {
        this.streamAttachmentStore.deleteTemporaryAttachment(temporaryAttachmentId).recover((com.google.common.base.Function)new com.google.common.base.Function<Throwable, Unit>(){

            public Unit apply(Throwable t) {
                log.info("Unable to delete temporary attachment with id " + temporaryAttachmentId, t);
                return Unit.VALUE;
            }
        }).claim();
    }

    public Either<AttachmentError, ChangeItemBean> convertTemporaryAttachment(ConvertTemporaryAttachmentParams params) {
        return this.createAttachmentFromTemporaryAttachment(params).right().map(ATTACHMENT_TO_CHANGE_ITEM_BEAN);
    }

    private <T> Either<AttachmentError, T> copyAttachmentError(Attachment attachment, @Nullable ApplicationUser author, String newIssueKey, Throwable throwable) {
        return this.attachmentError(String.format("Unable to copy attachment to issue with key %s.", newIssueKey), this.getI18n(author).getText("attachment.error.copy.generic", newIssueKey), attachment.getFilename(), throwable, ErrorCollection.Reason.SERVER_ERROR);
    }
}

