/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumberTools;

public class IssueKeyIndexer
extends BaseFieldIndexer {
    public IssueKeyIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    public String getId() {
        return SystemSearchConstants.forIssueKey().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forIssueKey().getIndexField();
    }

    public void addIndex(Document doc, Issue issue) {
        if (issue != null && !StringUtils.isBlank((String)issue.getKey())) {
            String key = issue.getKey();
            this.indexKeyword(doc, "key", key, issue);
            this.indexFoldedKeyword(doc, this.getDocumentFieldId(), key, Locale.ENGLISH, issue);
            long numPart = IssueKey.from((String)key).getIssueNumber();
            if (numPart >= 0L) {
                this.indexLongAsKeyword(doc, "keynumpart", numPart, issue);
                doc.add((Fieldable)new Field("keynumpart_range", NumberTools.longToString((long)numPart), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }
}

