/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@NonInjectableComponent
public class CascadingSelectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    public static final String CHILD_INDEX_SUFFIX = ":1";
    public static final String PARENT_AND_CHILD_INDEX_SUFFIX = "_combined";
    public static final String PARENT_AND_CHILD_INDEX_SEPARATOR = "|";
    private final CustomField customField;

    public CascadingSelectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Map) {
            Map cascadingOptions = (Map)value;
            this.indexParentField(cascadingOptions, doc, indexType);
            this.indexChildField(cascadingOptions, doc, indexType);
            this.indexParentAndChildField(cascadingOptions, doc, indexType);
        }
    }

    private void indexParentField(Map<String, Option> cascadingOptions, Document doc, Field.Index indexType) {
        Option value = cascadingOptions.get(CascadingSelectCFType.PARENT_KEY);
        if (value != null) {
            this.addField(doc, this.getDocumentFieldId(), value.getOptionId().toString(), indexType);
        }
    }

    private void indexChildField(Map<String, Option> cascadingOptions, Document doc, Field.Index indexType) {
        Option value = cascadingOptions.get("1");
        if (value != null) {
            String indexFieldName = this.getDocumentFieldId() + CHILD_INDEX_SUFFIX;
            this.addField(doc, indexFieldName, value.getOptionId().toString(), indexType);
        }
    }

    private void indexParentAndChildField(Map<String, Option> cascadingOptions, Document doc, Field.Index indexType) {
        Option parentValue = cascadingOptions.get(CascadingSelectCFType.PARENT_KEY);
        Option childValue = cascadingOptions.get("1");
        if (parentValue != null) {
            String combinedStringValue = null;
            combinedStringValue = childValue != null ? parentValue.getOptionId().toString() + PARENT_AND_CHILD_INDEX_SEPARATOR + childValue.getOptionId().toString() : parentValue.getOptionId().toString() + PARENT_AND_CHILD_INDEX_SEPARATOR;
            String indexFieldName = this.getDocumentFieldId() + PARENT_AND_CHILD_INDEX_SUFFIX;
            this.addField(doc, indexFieldName, combinedStringValue, indexType);
        }
    }

    private void addField(Document doc, String indexFieldName, String value, Field.Index indexType) {
        doc.add((Fieldable)new Field(indexFieldName, value, Field.Store.YES, indexType));
    }
}

