/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.LuceneVersion;
import com.atlassian.jira.issue.index.analyzer.BrazilianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.BulgarianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CJKAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CzechAnalyzer;
import com.atlassian.jira.issue.index.analyzer.EnglishAnalyzer;
import com.atlassian.jira.issue.index.analyzer.FrenchAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GermanAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GreekAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ItalianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.SimpleAnalyzer;
import com.atlassian.jira.issue.index.analyzer.StemmingAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ThaiAnalyzer;
import com.atlassian.jira.issue.index.analyzer.TokenFilters;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAnalyzer
extends Analyzer {
    private final boolean indexing;
    private final Stemming stemming;
    private final StopWordRemoval stopWordRemoval;
    private static final Logger log = LoggerFactory.getLogger(JiraAnalyzer.class);
    public static final Analyzer ANALYZER_FOR_INDEXING = new PerFieldIndexingAnalyzer();
    public static final Analyzer ANALYZER_FOR_SEARCHING = new JiraAnalyzer(false, Stemming.ON, StopWordRemoval.ON);
    public static final Analyzer ANALYZER_FOR_EXACT_SEARCHING = new JiraAnalyzer(false, Stemming.OFF, StopWordRemoval.OFF);
    @ClusterSafe(value="Lazy creation of expensive but stateless objects")
    private final LoadingCache<String, Analyzer> analyzers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Analyzer>(){

        public Analyzer load(@Nonnull String key) throws Exception {
            return JiraAnalyzer.this.makeAnalyzer(key);
        }
    });
    private final Analyzer fallbackAnalyzer;

    public JiraAnalyzer(boolean indexing, Stemming stemming, StopWordRemoval stopWordRemoval) {
        this.indexing = indexing;
        this.stemming = stemming;
        this.stopWordRemoval = stopWordRemoval;
        this.fallbackAnalyzer = new SimpleAnalyzer(LuceneVersion.get(), this.indexing);
    }

    Analyzer makeAnalyzer(String language) {
        if (language.equals("armenian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Armenian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Armenian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("basque")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Basque.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Basque.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("bulgarian")) {
            return new BulgarianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Bulgarian.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Bulgarian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("brazilian")) {
            return new BrazilianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Portuguese.Brazil.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Portuguese.Brazil.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("catalan")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Catalan.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Catalan.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("chinese")) {
            return new SimpleAnalyzer(LuceneVersion.get(), this.indexing);
        }
        if (language.equals("cjk")) {
            return new CJKAnalyzer(this.indexing, this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.CJK.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("czech")) {
            return new CzechAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Czech.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Czech.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("danish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Danish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Danish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("dutch")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Dutch.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Dutch.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english-moderate-stemming")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.moderate() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english-minimal-stemming")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.minimal() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("finnish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Finnish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Finnish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("french")) {
            return new FrenchAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.French.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.French.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("german")) {
            return new GermanAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.German.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.German.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("greek")) {
            return new GreekAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Greek.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Greek.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("hungarian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Hungarian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Hungarian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("italian")) {
            return new ItalianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Italian.Stemming.agressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Italian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("norwegian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Norwegian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Norwegian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("portuguese")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Portuguese.Portugal.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Portuguese.Portugal.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("romanian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Romanian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Romanian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("russian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Russian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Russian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("spanish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Spanish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Spanish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("swedish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Swedish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Swedish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("thai")) {
            return new ThaiAnalyzer(LuceneVersion.get(), this.indexing, this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Thai.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("other")) {
            return this.fallbackAnalyzer;
        }
        return this.fallbackAnalyzer;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        if (fieldname == null) {
            fieldname = "";
        }
        return this.findAnalyzer().tokenStream(fieldname, reader);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return super.reusableTokenStream(fieldName, reader);
    }

    private Analyzer findAnalyzer() {
        String language = this.getLanguage();
        if (language == null) {
            return this.fallbackAnalyzer;
        }
        Analyzer analyzer = null;
        try {
            analyzer = (Analyzer)this.analyzers.get((Object)language);
        }
        catch (ExecutionException e) {
            log.error("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'.");
            analyzer = this.fallbackAnalyzer;
        }
        if (analyzer == null) {
            log.error("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'.");
            analyzer = this.fallbackAnalyzer;
        }
        return analyzer;
    }

    String getLanguage() {
        return ComponentAccessor.getApplicationProperties().getString("jira.i18n.language.index");
    }

    private static class PerFieldIndexingAnalyzer
    extends Analyzer {
        private final Analyzer PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER = new JiraAnalyzer(true, Stemming.OFF, StopWordRemoval.OFF);
        private final Analyzer TEXT_FIELD_INDEXING_ANALYZER = new JiraAnalyzer(true, Stemming.ON, StopWordRemoval.ON);

        private PerFieldIndexingAnalyzer() {
        }

        public final TokenStream tokenStream(String fieldName, Reader reader) {
            if (PhraseQuerySupportField.isPhraseQuerySupportField((String)fieldName)) {
                return this.PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER.tokenStream(fieldName, reader);
            }
            return this.TEXT_FIELD_INDEXING_ANALYZER.tokenStream(fieldName, reader);
        }

        public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            if (PhraseQuerySupportField.isPhraseQuerySupportField((String)fieldName)) {
                return this.PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER.reusableTokenStream(fieldName, reader);
            }
            return this.TEXT_FIELD_INDEXING_ANALYZER.reusableTokenStream(fieldName, reader);
        }
    }

    public static enum StopWordRemoval {
        ON,
        OFF;

    }

    public static enum Stemming {
        ON,
        OFF;

    }
}

