/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.option.LazyLoadedOptionSet;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetPersister;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionSetPersisterImpl
implements OptionSetPersister {
    private static final Logger log = LoggerFactory.getLogger(OptionSetPersisterImpl.class);
    private final OfBizDelegator delegator;
    private final ConstantsManager constantsManager;

    public OptionSetPersisterImpl(OfBizDelegator delegator, ConstantsManager constantsManager) {
        this.delegator = delegator;
        this.constantsManager = constantsManager;
    }

    @Override
    public OptionSet create(FieldConfig config, Collection optionIds) {
        return this.update(config, optionIds);
    }

    @Override
    public OptionSet update(FieldConfig config, Collection optionIds) {
        Long configId = config.getId();
        String fieldId = config.getFieldId();
        this.delegator.removeByAnd("OptionConfiguration", (Map)FieldMap.build((String)"fieldconfig", (Object)configId, (String)"fieldid", (Object)fieldId));
        if (optionIds != null) {
            int i = 0;
            for (Object optionId : optionIds) {
                String option = (String)optionId;
                this.delegator.createValue("OptionConfiguration", MapBuilder.build((Object)"fieldconfig", (Object)configId, (Object)"fieldid", (Object)fieldId, (Object)"optionid", (Object)option, (Object)"sequence", (Object)new Long(i)));
                ++i;
            }
        } else {
            log.info("All options removed for config id" + config.getId());
        }
        return this.getOptionSetByConfig(config);
    }

    @Override
    public OptionSet getOptionSetByConfig(FieldConfig config) {
        List gvs = this.delegator.findByAnd("OptionConfiguration", (Map)FieldMap.build((String)"fieldconfig", (Object)config.getId(), (String)"fieldid", (Object)config.getFieldId()), EasyList.build((Object)"sequence ASC"));
        LazyLoadedOptionSet optionSet = new LazyLoadedOptionSet(this.constantsManager);
        for (GenericValue optionConfigGv : gvs) {
            optionSet.addOption(optionConfigGv.getString("fieldid"), optionConfigGv.getString("optionid"));
        }
        return optionSet;
    }
}

