/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.GenericValueFunctions;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.NotNullHashMap;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfigSchemePersisterImpl
implements FieldConfigSchemePersister {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemePersisterImpl.class);
    public static final String ENTITY_TABLE_NAME = "FieldConfigScheme";
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_DESCRIPTION = "description";
    public static final String ENTITY_FIELD = "fieldid";
    public static final String ENTITY_RELATED_TABLE_NAME = "FieldConfigSchemeIssueType";
    public static final String ENTITY_ISSUE_TYPE = "issuetype";
    public static final String ENTITY_SCHEME_ID = "fieldconfigscheme";
    public static final String ENTITY_CONFIG_ID = "fieldconfiguration";
    public static final String FK_RELATED_CONFIGS = "RelatedFieldConfigSchemeIssueType";
    private final OfBizDelegator ofBizDelegator;
    private final ConstantsManager constantsManager;
    private final FieldConfigPersister fieldConfigPersister;
    private final FieldConfigContextPersister contextPersister;
    private final CachedReference<Map<Long, GenericValue>> fieldConfigSchemesById;
    private final CachedReference<Multimap<Long, GenericValue>> fieldConfigSchemeIssueTypesBySchemeId;

    public FieldConfigSchemePersisterImpl(OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister contextPersister, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.constantsManager = constantsManager;
        this.fieldConfigPersister = fieldConfigPersister;
        this.contextPersister = contextPersister;
        this.fieldConfigSchemesById = cacheManager.getCachedReference(FieldConfigSchemePersisterImpl.class, "fieldConfigSchemesById", (Supplier)new FieldConfigSchemeCacheLoader());
        this.fieldConfigSchemeIssueTypesBySchemeId = cacheManager.getCachedReference(FieldConfigSchemePersisterImpl.class, "fieldConfigSchemeIssueTypesBySchemeId", (Supplier)new FieldConfigSchemeIssueTypesCacheLoader());
    }

    @Override
    public FieldConfigScheme create(FieldConfigScheme configScheme, ConfigurableField field) {
        Map<String, Object> fields = this.transformToFieldsMap(configScheme);
        fields.put(ENTITY_FIELD, field.getId());
        try {
            GenericValue createdGV = this.ofBizDelegator.createValue(ENTITY_TABLE_NAME, fields);
            Long createdId = createdGV.getLong(ENTITY_ID);
            this.storeConfigAssociations(configScheme.getConfigs(), createdId);
            this.invalidateAll();
            return this.transformToDomainObject(createdGV, field);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to create FieldConfigScheme with values " + fields, (Throwable)e);
        }
    }

    @Override
    public FieldConfigScheme createWithDefaultValues(ConfigurableField field, Map<String, FieldConfig> configs) {
        FieldConfigScheme.Builder scheme = this.createBuilder();
        scheme.setName(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.customfields.default.config.scheme", field.getName()));
        scheme.setDescription(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.customfields.default.config.description"));
        scheme.setConfigs(configs);
        return this.create(scheme.toFieldConfigScheme(), field);
    }

    @Override
    public Collection<FieldConfigScheme> getInvalidFieldConfigSchemeAfterIssueTypeRemoval(IssueType issueType) {
        Assertions.notNull((String)"issueType", (Object)issueType);
        HashSet<FieldConfigScheme> ret = new HashSet<FieldConfigScheme>();
        List gvs = this.ofBizDelegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_ISSUE_TYPE, (Object)issueType.getId()));
        for (GenericValue fieldConfigSchemeIssueTypeGV : gvs) {
            Long fieldConfigSchemeId = fieldConfigSchemeIssueTypeGV.getLong(ENTITY_SCHEME_ID);
            List specificSchemes = this.ofBizDelegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_SCHEME_ID, (Object)fieldConfigSchemeId));
            if (specificSchemes.size() != 1) continue;
            ret.add(this.getFieldConfigScheme(fieldConfigSchemeId));
        }
        return ret;
    }

    @Override
    public void removeByIssueType(IssueType issueType) {
        Assertions.notNull((String)"issueType", (Object)issueType);
        this.ofBizDelegator.removeByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_ISSUE_TYPE, (Object)issueType.getId()));
        this.invalidateAll();
    }

    @Override
    public void init() {
        this.invalidateAll();
    }

    @Override
    public FieldConfigScheme update(FieldConfigScheme configScheme) {
        try {
            GenericValue gv = this.findById(configScheme.getId());
            Map<String, Object> fields = this.transformToFieldsMap(configScheme);
            gv.setNonPKFields(fields);
            gv.store();
            this.removeRelatedConfigsForUpdate(configScheme, gv);
            gv.removeRelated(FK_RELATED_CONFIGS);
            this.storeConfigAssociations(configScheme.getConfigs(), configScheme.getId());
            this.invalidateAll();
            return this.getFieldConfigScheme(configScheme.getId());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to store FieldConfigScheme: " + configScheme, (Throwable)e);
        }
    }

    protected void removeRelatedConfigsForUpdate(@Nonnull FieldConfigScheme configScheme, @Nonnull GenericValue gv) throws GenericEntityException {
        gv.removeRelated(FK_RELATED_CONFIGS);
    }

    @Override
    public void remove(Long fieldConfigSchemeId) {
        this.removeIfExist(fieldConfigSchemeId);
    }

    @Nullable
    protected FieldConfigScheme removeIfExist(Long fieldConfigSchemeId) {
        try {
            GenericValue gv = this.findById(fieldConfigSchemeId);
            if (gv == null) {
                return null;
            }
            gv.removeRelated(FK_RELATED_CONFIGS);
            gv.remove();
            this.invalidateAll();
            return this.transformToDomainObject(gv, null);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to remove FieldConfigScheme with id '" + fieldConfigSchemeId + '\'', (Throwable)e);
        }
    }

    @Override
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        GenericValue gv = this.getById(configSchemeId);
        return this.transformToDomainObject(gv, null);
    }

    @Override
    public List<FieldConfigScheme> getConfigSchemesForCustomField(final ConfigurableField field) {
        ArrayList configs = Lists.newArrayList((Iterable)Iterables.filter(((Map)this.fieldConfigSchemesById.get()).values(), (Predicate)new Predicate<GenericValue>(){

            public boolean apply(GenericValue genericValue) {
                return genericValue.getString(FieldConfigSchemePersisterImpl.ENTITY_FIELD).equals(field.getId());
            }
        }));
        Collections.sort(configs, new Comparator<GenericValue>(){

            @Override
            public int compare(GenericValue gv1, GenericValue gv2) {
                return Longs.compare((long)gv1.getLong(FieldConfigSchemePersisterImpl.ENTITY_ID), (long)gv2.getLong(FieldConfigSchemePersisterImpl.ENTITY_ID));
            }
        });
        return CollectionUtil.transform((Iterable)configs, (Function)new Function<GenericValue, FieldConfigScheme>(){

            public FieldConfigScheme get(GenericValue input) {
                return FieldConfigSchemePersisterImpl.this.transformToDomainObject(input, field);
            }
        });
    }

    @Override
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        Long fieldConfigId = fieldConfig.getId();
        List configs = this.ofBizDelegator.findByAnd(ENTITY_RELATED_TABLE_NAME, MapBuilder.build((Object)ENTITY_CONFIG_ID, (Object)fieldConfigId));
        if (configs.isEmpty()) {
            throw new DataAccessException(String.format("Could not find any field config schemes for field config '%d'", fieldConfigId));
        }
        if (configs.size() > 1) {
            log.warn(String.format("Found more than one field config scheme for field config '%d'; returning first one", fieldConfigId));
        }
        Long fieldConfigSchemeId = ((GenericValue)configs.get(0)).getLong(ENTITY_SCHEME_ID);
        return this.getFieldConfigScheme(fieldConfigSchemeId);
    }

    @Override
    public List<Long> getConfigSchemeIdsForCustomFieldId(String customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        List configs = this.ofBizDelegator.findByAnd(ENTITY_TABLE_NAME, MapBuilder.build((Object)ENTITY_FIELD, (Object)customFieldId));
        return CollectionUtil.transform((Iterable)configs, (Function)GenericValueFunctions.getLong(ENTITY_ID));
    }

    private Map<String, Object> transformToFieldsMap(FieldConfigScheme configScheme) {
        NotNullHashMap<String, Object> fields = new NotNullHashMap<String, Object>();
        fields.put(ENTITY_ID, configScheme.getId());
        fields.put(ENTITY_NAME, configScheme.getName());
        fields.put(ENTITY_DESCRIPTION, configScheme.getDescription());
        return fields;
    }

    @Nullable
    FieldConfigScheme transformToDomainObject(GenericValue createdGV, ConfigurableField field) {
        if (createdGV == null) {
            return null;
        }
        FieldConfigScheme.Builder configScheme = this.createBuilder();
        configScheme.setId(createdGV.getLong(ENTITY_ID));
        configScheme.setName(createdGV.getString(ENTITY_NAME));
        configScheme.setDescription(createdGV.getString(ENTITY_DESCRIPTION));
        configScheme.setFieldId(createdGV.getString(ENTITY_FIELD));
        List related = (List)((Multimap)this.fieldConfigSchemeIssueTypesBySchemeId.get()).get((Object)createdGV.getLong(ENTITY_ID));
        if (related != null && !related.isEmpty()) {
            HashMap<String, FieldConfig> configs = new HashMap<String, FieldConfig>(related.size());
            for (GenericValue gv : related) {
                IssueType issueType = this.constantsManager.getIssueTypeObject(gv.getString(ENTITY_ISSUE_TYPE));
                Long configId = gv.getLong(ENTITY_CONFIG_ID);
                FieldConfig config = field != null ? this.fieldConfigPersister.getFieldConfig(configId, field) : this.fieldConfigPersister.getFieldConfig(configId);
                if (config == null) continue;
                String key = issueType == null ? null : issueType.getId();
                configs.put(key, config);
            }
            configScheme.setConfigs(configs);
        }
        return configScheme.toFieldConfigScheme();
    }

    private GenericValue findById(Long configId) {
        return this.ofBizDelegator.findById(ENTITY_TABLE_NAME, configId);
    }

    private GenericValue getById(Long id) {
        return (GenericValue)((Map)this.fieldConfigSchemesById.get()).get(id);
    }

    private void storeConfigAssociations(Map<String, FieldConfig> configs, Long createdId) throws GenericEntityException {
        if (configs != null) {
            Set<Map.Entry<String, FieldConfig>> entries = configs.entrySet();
            for (Map.Entry<String, FieldConfig> entry : entries) {
                String issueType = entry.getKey();
                FieldConfig config = entry.getValue();
                FieldMap relatedFields = FieldMap.build((String)ENTITY_ISSUE_TYPE, (Object)issueType, (String)ENTITY_SCHEME_ID, (Object)createdId, (String)ENTITY_CONFIG_ID, (Object)config.getId());
                this.ofBizDelegator.createValue(ENTITY_RELATED_TABLE_NAME, (Map)relatedFields);
            }
            this.invalidateAll();
        }
    }

    private FieldConfigScheme.Builder createBuilder() {
        FieldConfigScheme.Builder configScheme = new FieldConfigScheme.Builder();
        configScheme.setFieldConfigContextPersister(this.contextPersister);
        return configScheme;
    }

    protected void invalidateAll() {
        this.fieldConfigSchemesById.reset();
        this.fieldConfigSchemeIssueTypesBySchemeId.reset();
    }

    private class FieldConfigSchemeIssueTypesCacheLoader
    implements Supplier<Multimap<Long, GenericValue>> {
        private FieldConfigSchemeIssueTypesCacheLoader() {
        }

        public Multimap<Long, GenericValue> get() {
            List genericValues = FieldConfigSchemePersisterImpl.this.ofBizDelegator.findAll(FieldConfigSchemePersisterImpl.ENTITY_RELATED_TABLE_NAME);
            ArrayListMultimap cacheValues = ArrayListMultimap.create();
            for (GenericValue genericValue : genericValues) {
                cacheValues.put((Object)genericValue.getLong(FieldConfigSchemePersisterImpl.ENTITY_SCHEME_ID), (Object)genericValue);
            }
            return cacheValues;
        }
    }

    private class FieldConfigSchemeCacheLoader
    implements Supplier<Map<Long, GenericValue>> {
        private FieldConfigSchemeCacheLoader() {
        }

        public Map<Long, GenericValue> get() {
            List genericValues = FieldConfigSchemePersisterImpl.this.ofBizDelegator.findAll(FieldConfigSchemePersisterImpl.ENTITY_TABLE_NAME);
            HashMap cacheValues = Maps.newHashMap();
            for (GenericValue genericValue : genericValues) {
                cacheValues.put(genericValue.getLong(FieldConfigSchemePersisterImpl.ENTITY_ID), genericValue);
            }
            return cacheValues;
        }
    }
}

