/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.CreatorSearchHandlerFactory;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.statistics.CreatorStatisticsMapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatorSystemField
extends NavigableFieldImpl
implements SearchableField,
RestAwareField {
    private static final Logger log = LoggerFactory.getLogger(ReporterSystemField.class);
    private final SearchHandlerFactory searchHandlerFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final CreatorStatisticsMapper creatorStatisticsMapper;
    private final UserBeanFactory userBeanFactory;

    public CreatorSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, CreatorSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls, CreatorStatisticsMapper creatorStatisticsMapper, UserBeanFactory userBeanFactory) {
        super("creator", "issue.field.creator", "issue.column.heading.creator", "DESC", templatingEngine, applicationProperties, authenticationContext);
        this.searchHandlerFactory = searchHandlerFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.creatorStatisticsMapper = creatorStatisticsMapper;
        this.userBeanFactory = userBeanFactory;
    }

    public LuceneFieldSorter getSorter() {
        return this.creatorStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        try {
            String creatorUserId = issue.getCreatorId();
            if (creatorUserId != null) {
                velocityParams.put("creatorUserkey", creatorUserId);
            }
        }
        catch (DataAccessException e) {
            log.debug("Error occurred retrieving creator", (Throwable)e);
        }
        return this.renderTemplate("creator-columnview.vm", velocityParams);
    }

    public SearchHandler createAssociatedSearchHandler() {
        return this.searchHandlerFactory.createHandler(this);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String autoCompleteUrl = String.format("%s/rest/api/latest/user/search?username=", this.jiraBaseUrls.baseUrl());
        return new FieldTypeInfo(null, autoCompleteUrl);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"user", (String)"creator");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)this.userBeanFactory.createBean(issue.getCreator(), this.authenticationContext.getUser())));
    }
}

