/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class ProjectImportResultsImpl
implements ProjectImportResults {
    private static final long serialVersionUID = -564712258696084710L;
    private transient Project importedProject;
    private transient I18nHelper i18n;
    private Long importedProjectId;
    private final List<String> errors;
    private final List<Pair<String, Long>> results;
    private final Map<String, AtomicInteger> roleUsersCreatedCountByRole;
    private final Map<String, AtomicInteger> roleGroupsCreatedCountByRole;
    private final Set<String> roles;
    private final AtomicInteger issuesCreatedCount;
    private final AtomicInteger usersCreatedCount;
    private final AtomicInteger attachmentsCreatedCount;
    private final AtomicInteger errorCount;
    private final long startTime;
    private final int expectedIssuesCreatedCount;
    private final int expectedUsersCreatedCount;
    private final int expectedAttachmentsCreatedCount;
    private long endTime;
    private boolean importCompleted;

    public ProjectImportResultsImpl(long startTime, int expectedIssuesCreatedCount, int expectedUsersCreatedCount, int expectedAttachmentsCreatedCount, I18nHelper i18n) {
        this.startTime = startTime;
        this.expectedIssuesCreatedCount = expectedIssuesCreatedCount;
        this.expectedUsersCreatedCount = expectedUsersCreatedCount;
        this.expectedAttachmentsCreatedCount = expectedAttachmentsCreatedCount;
        this.i18n = i18n;
        this.issuesCreatedCount = new AtomicInteger(0);
        this.usersCreatedCount = new AtomicInteger(0);
        this.errorCount = new AtomicInteger(0);
        this.attachmentsCreatedCount = new AtomicInteger(0);
        this.errors = Collections.synchronizedList(new ArrayList());
        this.roleUsersCreatedCountByRole = new HashMap<String, AtomicInteger>();
        this.roleGroupsCreatedCountByRole = new HashMap<String, AtomicInteger>();
        this.roles = Collections.synchronizedSet(new TreeSet());
        this.results = new ArrayList<Pair<String, Long>>();
    }

    public long getImportDuration() {
        return this.endTime - this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @ClusterSafe(value="SESSION AFFINITY")
    public synchronized void incrementRoleUserCreatedCount(String roleName) {
        AtomicInteger roleUsersCreated = this.roleUsersCreatedCountByRole.get(roleName);
        if (roleUsersCreated == null) {
            roleUsersCreated = new AtomicInteger(0);
            this.roleUsersCreatedCountByRole.put(roleName, roleUsersCreated);
            this.roles.add(roleName);
        }
        roleUsersCreated.incrementAndGet();
    }

    @ClusterSafe(value="SESSION AFFINITY")
    public synchronized void incrementRoleGroupCreatedCount(String roleName) {
        AtomicInteger roleGroupsCreated = this.roleGroupsCreatedCountByRole.get(roleName);
        if (roleGroupsCreated == null) {
            roleGroupsCreated = new AtomicInteger(0);
            this.roleGroupsCreatedCountByRole.put(roleName, roleGroupsCreated);
            this.roles.add(roleName);
        }
        roleGroupsCreated.incrementAndGet();
    }

    public Collection<String> getRoles() {
        return Collections.unmodifiableCollection(this.roles);
    }

    public int getGroupsCreatedCountForRole(String roleName) {
        AtomicInteger groupsCreatedForRole = this.roleGroupsCreatedCountByRole.get(roleName);
        if (groupsCreatedForRole != null) {
            return groupsCreatedForRole.get();
        }
        return 0;
    }

    public int getUsersCreatedCountForRole(String roleName) {
        AtomicInteger usersCreatedForRole = this.roleUsersCreatedCountByRole.get(roleName);
        if (usersCreatedForRole != null) {
            return usersCreatedForRole.get();
        }
        return 0;
    }

    public void addError(String error) {
        this.errors.add(error);
        this.errorCount.incrementAndGet();
    }

    int getErrorCountLimit() {
        return 10;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean isImportCompleted() {
        return this.importCompleted;
    }

    public void incrementIssuesCreatedCount() {
        this.issuesCreatedCount.incrementAndGet();
    }

    public void incrementUsersCreatedCount() {
        this.usersCreatedCount.incrementAndGet();
    }

    public void incrementAttachmentsCreatedCount() {
        this.attachmentsCreatedCount.incrementAndGet();
    }

    public int getIssuesCreatedCount() {
        return this.issuesCreatedCount.get();
    }

    public int getUsersCreatedCount() {
        return this.usersCreatedCount.get();
    }

    public int getAttachmentsCreatedCount() {
        return this.attachmentsCreatedCount.get();
    }

    public int getExpectedIssuesCreatedCount() {
        return this.expectedIssuesCreatedCount;
    }

    public int getExpectedUsersCreatedCount() {
        return this.expectedUsersCreatedCount;
    }

    public int getExpectedAttachmentsCreatedCount() {
        return this.expectedAttachmentsCreatedCount;
    }

    public void setImportCompleted(boolean importCompleted) {
        this.importCompleted = importCompleted;
    }

    public Project getImportedProject() {
        return this.importedProject;
    }

    public void setImportedProject(Project importedProject) {
        this.importedProject = importedProject;
        this.importedProjectId = importedProject.getId();
    }

    public I18nHelper getI18n() {
        return this.i18n;
    }

    public boolean abortImport() {
        return this.errorCount.get() >= this.getErrorCountLimit();
    }

    private Object readResolve() {
        this.i18n = (I18nHelper)ComponentAccessor.getComponent(I18nHelper.class);
        if (this.importedProjectId != null) {
            this.importedProject = ((ProjectManager)ComponentAccessor.getComponent(ProjectManager.class)).getProjectObj(this.importedProjectId);
        }
        return this;
    }

    public void addResult(long count, String msgKey) {
        this.results.add((Pair<String, Long>)Pair.pair((Object)this.i18n.getText(msgKey), (Object)count));
    }

    public List<Pair<String, Long>> getResults() {
        return this.results;
    }
}

