/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.ao.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.ao.handler.AoEntityHandler;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.imports.project.util.XMLEscapeUtil;
import com.atlassian.jira.util.xml.SecureXmlEntityResolver;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChainedAoSaxHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ChainedAoSaxHandler.class);
    public static final SecureXmlEntityResolver EMPTY_ENTITY_RESOLVER = new SecureXmlEntityResolver();
    public static final String AO_BACKUP_XML = "backup";
    public static final String DATA = "data";
    public static final String TABLE_NAME = "tableName";
    public static final String COLUMN = "column";
    public static final String COLUMN_NAME = "name";
    public static final String ROW = "row";
    public static final String STRING = "string";
    public static final String INTEGER = "integer";
    public static final String DOUBLE = "double";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "timestamp";
    private Map<String, Object> rowData;
    private String inEntity = null;
    private StringBuffer textBuffer;
    private boolean hasRootElement = false;
    private long entityCount;
    private int entityTypeCount;
    private long currentEntityCount;
    final Collection<AoEntityHandler> delegateHandlers = new ArrayList<AoEntityHandler>();
    private final TaskProgressProcessor taskProgressProcessor;
    private String currentTable = null;
    private List<String> tableColumns = new ArrayList<String>();
    private int columnIndex = 0;

    public ChainedAoSaxHandler(TaskProgressProcessor taskProgressProcessor) {
        this.taskProgressProcessor = taskProgressProcessor;
    }

    public ChainedAoSaxHandler() {
        this.taskProgressProcessor = null;
    }

    public void registerHandler(AoEntityHandler handler) {
        this.delegateHandlers.add(handler);
    }

    public void registerHandlers(Iterable<? extends AoEntityHandler> aoPluginPreImportHandlers) {
        for (AoEntityHandler aoEntityHandler : aoPluginPreImportHandlers) {
            this.registerHandler(aoEntityHandler);
        }
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return EMPTY_ENTITY_RESOLVER.resolveEntity(publicId, systemId);
    }

    @Override
    public final void startDocument() throws SAXException {
        log.debug("Starting parsing Document with ChainedAoSaxHandler.");
        this.entityCount = 0L;
        for (AoEntityHandler ImportAoEntityHandler : this.delegateHandlers) {
            ImportAoEntityHandler.startDocument();
        }
        this.processTaskProgress("Start");
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.hasRootElement) {
            throw new SAXException("XML file ended too early.  There was no </entity-engine-xml> tag.");
        }
        for (AoEntityHandler ImportAoEntityHandler : this.delegateHandlers) {
            ImportAoEntityHandler.endDocument();
        }
        log.debug("Ended parsing Document with ChainedAoSaxHandler.");
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.hasRootElement) {
            this.startElement(qName, attributes);
        } else if (AO_BACKUP_XML.equals(qName)) {
            this.hasRootElement = true;
        } else {
            throw new SAXException("The XML document does not contain the <backup> root element or it was closed too early.");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasRootElement) {
            if (AO_BACKUP_XML.equals(qName)) {
                this.hasRootElement = false;
            } else {
                this.endElement(qName);
            }
        } else {
            throw new SAXException("How did we get here an exception should already have been thrown");
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        String s = XMLEscapeUtil.unicodeDecode(new String(ch, start, length));
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    private void startElement(String qName, Attributes attributes) {
        if (DATA.equals(qName)) {
            this.currentTable = this.decode(attributes.getValue(TABLE_NAME));
            this.tableColumns.clear();
        } else if (this.currentTable != null) {
            if (COLUMN.equals(qName)) {
                this.tableColumns.add(this.decode(attributes.getValue(COLUMN_NAME)));
            } else if (ROW.equals(qName)) {
                this.inEntity = this.currentTable;
                this.rowData = new HashMap<String, Object>();
                this.columnIndex = 0;
            } else if (this.inEntity != null) {
                this.textBuffer = null;
            }
        }
    }

    private void endElement(String qName) throws SAXException {
        if (DATA.equals(qName)) {
            this.endTable(this.currentTable);
        } else if (this.currentTable != null) {
            if (ROW.equals(qName)) {
                this.endRow(this.currentTable);
            } else if (this.inEntity != null) {
                if (this.columnIndex < this.tableColumns.size()) {
                    this.endNestedElement(this.tableColumns.get(this.columnIndex), qName);
                } else {
                    log.debug("Expected {} columns for table [{}], but tried to look up column {}", new Object[]{this.tableColumns.size(), this.currentTable, this.columnIndex});
                }
                ++this.columnIndex;
            }
        }
    }

    private void endNestedElement(String column, String type) throws SAXException {
        Object value = null;
        if (this.textBuffer != null) {
            if (STRING.equals(type)) {
                value = this.decode(this.textBuffer.toString());
            } else if (INTEGER.equals(type)) {
                value = Long.valueOf(this.textBuffer.toString());
            } else if (DOUBLE.equals(type)) {
                value = Double.valueOf(this.textBuffer.toString());
            } else if (BOOLEAN.equals(type)) {
                value = Boolean.valueOf(this.textBuffer.toString());
            } else if (DATE.equals(type)) {
                try {
                    value = this.newDateFormat().parse(this.textBuffer.toString());
                }
                catch (java.text.ParseException e) {
                    throw new SAXException(e);
                }
            } else {
                throw new SAXException("Unrecognised AO Data Type");
            }
        }
        this.rowData.put(column, value);
        this.textBuffer = null;
    }

    private DateFormat newDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    private void endTable(String tableName) {
        ++this.entityTypeCount;
        this.currentEntityCount = 0L;
        this.currentTable = null;
        for (AoEntityHandler importAoEntityHandler : this.delegateHandlers) {
            if (!importAoEntityHandler.handlesEntity(tableName)) continue;
            importAoEntityHandler.endTable(tableName);
        }
    }

    private void endRow(String tableName) throws SAXException {
        this.inEntity = null;
        try {
            ++this.entityCount;
            ++this.currentEntityCount;
            this.processTaskProgress(tableName);
            for (AoEntityHandler importAoEntityHandler : this.delegateHandlers) {
                if (!importAoEntityHandler.handlesEntity(tableName)) continue;
                importAoEntityHandler.handleEntity(tableName, this.rowData);
            }
        }
        catch (ParseException e) {
            log.warn("Encountered a parsing exception.", (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
    }

    private void processTaskProgress(String qName) {
        if (this.taskProgressProcessor != null && this.callMakeProgress()) {
            this.taskProgressProcessor.processTaskProgress(qName, this.entityTypeCount, this.entityCount, this.currentEntityCount);
        }
    }

    private String decode(String value) {
        return XMLEscapeUtil.unicodeDecode(value);
    }

    boolean callMakeProgress() {
        return this.entityCount % 100L == 0L;
    }
}

