/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.DefaultHelpUrlsParser;
import com.atlassian.jira.help.DefaultLocalHelpUrls;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.SimpleHelpUrlBuilder;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticHelpUrls {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHelpUrls.class);

    public static HelpUrls getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final String RESOURCE = "help-paths.properties";
        private static final HelpUrls INSTANCE = Holder.loadHelpUrls();

        private Holder() {
        }

        private static HelpUrls loadHelpUrls() {
            DefaultLocalHelpUrls localHelpUrls = new DefaultLocalHelpUrls();
            Supplier onDemand = Suppliers.ofInstance((Object)Boolean.FALSE);
            SimpleHelpUrlBuilder.Factory builder = new SimpleHelpUrlBuilder.Factory(new BuildUtilsInfoImpl());
            DefaultHelpUrlsParser parser = new DefaultHelpUrlsParser(builder, localHelpUrls, (Supplier<Boolean>)onDemand, null, null);
            return parser.parse(Holder.readProperties());
        }

        private static Properties readProperties() {
            Properties properties = new Properties();
            InputStream stream = StaticHelpUrls.class.getClassLoader().getResourceAsStream(RESOURCE);
            try {
                if (stream != null) {
                    properties.load(stream);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to read in 'help-paths.properties.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            return properties;
        }
    }
}

