/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrlBuilder;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

abstract class HelpUrlBuilderFactoryTemplate
implements HelpUrlBuilder.Factory {
    private static final Pattern DOC_VERSION_SUB = Pattern.compile("\\$\\{docs?\\.version\\}");
    private final BuildUtilsInfo buildNumbers;

    HelpUrlBuilderFactoryTemplate(BuildUtilsInfo buildNumbers) {
        this.buildNumbers = buildNumbers;
    }

    @Override
    public final HelpUrlBuilder get(String prefix, String suffix) {
        return this.newUrlBuilder(this.substitute(StringUtils.trimToNull((String)prefix)), StringUtils.trimToNull((String)suffix));
    }

    private String substitute(String string) {
        if (string == null) {
            return null;
        }
        return DOC_VERSION_SUB.matcher(string).replaceAll(this.buildNumbers.getDocVersion());
    }

    abstract HelpUrlBuilder newUrlBuilder(String var1, String var2);
}

