/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.jira.crowd.embedded.JiraDirectorySynchroniser;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class JiraDirectoryPollerManager
implements DirectoryPollerManager {
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JiraDirectoryPollerManager.class.getName());
    public static final String DIRECTORY_ID = "DIRECTORY_ID";
    private final SchedulerService schedulerService;

    public JiraDirectoryPollerManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new JiraDirectorySynchroniser());
    }

    public void addPoller(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        Date oneMinuteFromNow = new DateTime().plusMinutes(1).toDate();
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)(poller.getPollingInterval() * 1000L), (Date)oneMinuteFromNow)).withParameters((Map)ImmutableMap.of((Object)DIRECTORY_ID, (Object)poller.getDirectoryID()));
        try {
            this.schedulerService.scheduleJob(this.getJobId(poller), config);
        }
        catch (SchedulerServiceException e) {
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
    }

    private JobId getJobId(DirectoryPoller poller) {
        long directoryID = poller.getDirectoryID();
        return this.getJobId(directoryID);
    }

    private JobId getJobId(long directoryID) {
        return JobId.of((String)(JiraDirectoryPollerManager.class.getName() + "." + directoryID));
    }

    public boolean hasPoller(long directoryID) {
        JobDetails jobDetails = this.schedulerService.getJobDetails(this.getJobId(directoryID));
        return jobDetails != null;
    }

    public void triggerPoll(long directoryID, SynchronisationMode synchronisationMode) {
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)).withParameters((Map)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryID));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(config);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean removePoller(long directoryID) throws DirectoryMonitorUnregistrationException {
        boolean exists = this.hasPoller(directoryID);
        this.schedulerService.unscheduleJob(this.getJobId(directoryID));
        return exists;
    }

    public void removeAllPollers() {
        List jobs = this.schedulerService.getJobsByJobRunnerKey(JOB_RUNNER_KEY);
        for (JobDetails job : jobs) {
            this.schedulerService.unscheduleJob(job.getJobId());
        }
    }
}

