/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webwork.WebworkModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.ConfigurationInterface;
import webwork.config.DelegatingConfiguration;
import webwork.config.WebworkConfigurationNotFoundException;

public class JiraPluginsConfiguration
implements ConfigurationInterface {
    private static final Logger log = LoggerFactory.getLogger(JiraPluginsConfiguration.class);
    private final PluginSystemAccessor pluginSystemAccessor = new PluginSystemAccessor();

    public Object getImpl(String aName) throws IllegalArgumentException {
        if (this.isBlackListedKey(StringUtils.defaultString((String)aName))) {
            throw new WebworkConfigurationNotFoundException(this.getClass(), "No such setting", aName);
        }
        return this.getConfig().getImpl(aName);
    }

    private boolean isBlackListedKey(String aName) {
        return aName.startsWith("webwork.");
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration does not support updating a setting");
    }

    public Iterator listImpl() {
        return this.getConfig().listImpl();
    }

    private ConfigurationInterface getConfig() {
        return this.pluginSystemAccessor.getConfig();
    }

    PluginAccessor getPluginAccessor() {
        return (PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class);
    }

    PluginEventManager getPluginEventManager() {
        return (PluginEventManager)ComponentAccessor.getComponentOfType(PluginEventManager.class);
    }

    class PluginSystemAccessor {
        final Listener shutdownListener = new Listener();
        volatile ConfigurationInterface config;

        PluginSystemAccessor() {
            JiraPluginsConfiguration.this.getPluginEventManager().register((Object)this.shutdownListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ClusterSafe(value="This is purely a local concern")
        ConfigurationInterface getConfig() {
            PluginSystemAccessor pluginSystemAccessor = this;
            synchronized (pluginSystemAccessor) {
                if (this.config == null) {
                    PluginAccessor pluginAccessor = JiraPluginsConfiguration.this.getPluginAccessor();
                    if (pluginAccessor.getPlugins() == null || pluginAccessor.getPlugins().isEmpty()) {
                        if (this.config == null) {
                            this.config = new NullConfig("JIRA plugin has not loaded yet - no properties available");
                        }
                    } else {
                        List<WebworkModuleDescriptor> configurations = this.getWebworkPluginConfigurations();
                        this.config = configurations.isEmpty() ? new NullConfig("No webwork plugins.") : new DelegatingConfiguration(configurations.toArray(new ConfigurationInterface[configurations.size()]));
                    }
                }
            }
            return this.config;
        }

        List<WebworkModuleDescriptor> getWebworkPluginConfigurations() {
            try {
                return JiraPluginsConfiguration.this.getPluginAccessor().getEnabledModuleDescriptorsByClass(WebworkModuleDescriptor.class);
            }
            catch (PluginParseException e) {
                log.error("Problem getting webwork module descriptors" + (Object)((Object)e), (Throwable)e);
                return null;
            }
        }

        public class Listener {
            @PluginEventListener
            public void onShutdown(PluginFrameworkShutdownEvent event) {
                PluginSystemAccessor.this.config = null;
            }
        }
    }

    private static class NullConfig
    implements ConfigurationInterface {
        private final String message;

        public NullConfig(String message) {
            this.message = message;
        }

        public Object getImpl(String aName) throws IllegalArgumentException {
            throw new IllegalArgumentException(this.message);
        }

        public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
            throw new UnsupportedOperationException("This configuration does not support updating a setting");
        }

        public Iterator listImpl() {
            throw new UnsupportedOperationException("This configuration does not support listing the settings");
        }
    }
}

